<?php $__env->startPush('style'); ?>
    <link rel="stylesheet" href="/assets/compiled/css/iconly.css">
    <link rel="stylesheet" href="/assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="./assets/compiled/css/table-datatable-jquery.css">
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/flatpickr/flatpickr.css')); ?>" />
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-10">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="card-title">Daftar Antrian</h4>
                        <button id="btnHapusSemua" class="btn btn-danger">Hapus Semua Antrian</button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="antrian_table" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Waktu Masuk</th>
                                        <th>Status</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $daftarAntrian; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $antrian): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="table_antrian">
                                            <td><?php echo e($antrian->queue->kuota); ?></td>
                                            <td><?php echo e($antrian->tanggal_masuk); ?></td>
                                            <td><?php echo e($antrian->status); ?></td>
                                            <td>
                                                <button
                                                    class="btn btn-sm btn-warning btn-selesai <?php if($antrian->status === 'Selesai' || $antrian->status === 'Menunggu'): ?> disabled <?php endif; ?>">
                                                    <i class="mdi mdi-check"></i>
                                                </button>
                                                <button
                                                    class="btn btn-sm btn-primary btn-panggil <?php if($antrian->status === 'Selesai'): ?> disabled <?php endif; ?>">
                                                    <i class="mdi mdi-microphone"></i>
                                                </button>
                                                <form action="<?php echo e(route('Operator.delete', $antrian->id)); ?>" method="POST"
                                                    style="display: inline;">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-sm btn-danger"
                                                        onclick="return confirm('Apakah Anda yakin ingin menghapus antrian ini?')">
                                                        <i class="mdi mdi-delete"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                            <?php echo e($daftarAntrian->links('pagination::bootstrap-5')); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <!-- Vendors JS -->
    <script src="<?php echo e(asset('assets/vendor/libs/flatpickr/flatpickr.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js')); ?>"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.0.3/css/buttons.dataTables.min.css">
    <script src="https://cdn.datatables.net/buttons/1.0.3/js/dataTables.buttons.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.0.3/css/buttons.dataTables.min.css">
    <script src="https://cdn.datatables.net/buttons/1.0.3/js/dataTables.buttons.min.js"></script>
    <script src="<?php echo e(asset('/vendor/datatables/buttons.server-side.js')); ?>"></script>

    <script>
        $(document).ready(function() {
            function updateQueueData() {
                $.ajax({
                    url: '/operator/get-latest-queue-data',
                    type: 'GET',
                    success: function(response) {
                        $('#latestQueue').text(response.latestQueue.kuota);

                        // Perbarui konten tabel
                        var tableBody = $('#antrian_table tbody');
                        tableBody.empty(); // Kosongkan konten tabel sebelum memasukkan data baru
                        $.each(response.daftarAntrian, function(index, antrian) {
                            var newRow = '<tr id="table_antrian">' +
                                '<td>' + antrian.queue.kuota + '</td>' +
                                '<td>' + antrian.tanggal_masuk + '</td>' +
                                '<td>' + antrian.status + '</td>' +
                                '<td class="d-flex gap-3">' +
                                '<button class="btn btn-sm btn-warning btn-selesai ' + (antrian
                                    .status === 'Selesai' || antrian.status === 'Menunggu' ?
                                    'disabled' : '') +
                                '"><i class="mdi mdi-check"></i></button>' +
                                '<button class="btn btn-sm btn-primary btn-panggil ' + (antrian
                                    .status === 'Selesai' ? 'disabled' : '') +
                                '"><i class="mdi mdi-microphone"></i></button>' +
                                '<form action="<?php echo e(route('Operator.delete', ':id')); ?>" method="POST" style="display: inline;">' +
                                '<?php echo csrf_field(); ?>' +
                                '<?php echo method_field('DELETE'); ?>' +
                                '<button type="submit" class="btn btn-sm btn-danger" onclick="return confirm(\'Apakah Anda yakin ingin menghapus antrian ini?\')"><i class="mdi mdi-delete"></i></button>' +
                                '</form>' +
                                '</td>' +
                                '</tr>';
                            tableBody.append(newRow);
                            <?php echo e($daftarAntrian->links('pagination::bootstrap-5')); ?>

                        });
                    },
                    error: function(xhr, status, error) {
                        console.error(error);
                    }
                });
            }
            setInterval(updateQueueData, 2000);

            $(document).on('click', '.btn-panggil', function() {
                var row = $(this).closest('tr');
                var id = row.find('td:first-child').text();
                var status = row.find('td:eq(2)').text();
                var operator = "<?php echo e($loggedInOperator); ?>";
                var updateUrl = "<?php echo e(route('Operator.update.status', ':id')); ?>";
                updateUrl = updateUrl.replace(':id', id);
                var csrfToken = $('meta[name="csrf-token"]').attr('content');

                if (status !== "Selesai") {
                    var msg = new SpeechSynthesisUtterance('Antrian nomor ' + id + ' menuju ' +
                        operator);
                    msg.lang = 'id-ID';
                    window.speechSynthesis.speak(msg);

                    var button = $(this);

                    $.ajax({
                        url: updateUrl,
                        type: 'PUT',
                        data: {
                            _token: csrfToken,
                            status: "Diproses"
                        },
                        success: function(response) {
                            button.closest('tr').find('td:eq(2)').text("Diproses");
                        }
                    });
                }
            });

            $(document).on('click', '.btn-selesai', function() {
                var row = $(this).closest('tr');
                var id = row.find('td:first-child').text();
                var status = row.find('td:eq(2)').text();
                var baseUrl = "<?php echo e(url('/')); ?>";
                var updateUrl = baseUrl + "/operator/antrian/status/check/" + id;
                var csrfToken = $('meta[name="csrf-token"]').attr('content');

                if (status !== "Selesai") {
                    var button = $(this);

                    $.ajax({
                        url: updateUrl,
                        type: 'PUT',
                        data: {
                            _token: csrfToken,
                            status: "Selesai"
                        },
                        success: function(response) {
                            button.closest('tr').find('td:eq(2)').text("Selesai");
                        }
                    });
                }
            });

            $('#btnHapusSemua').click(function() {
                if (confirm('Apakah Anda yakin ingin menghapus semua antrian?')) {
                    var baseUrl = "<?php echo e(url('/')); ?>";
                    var deleteAllUrl = baseUrl + "/operator/antrian";
                    var csrfToken = $('meta[name="csrf-token"]').attr('content');

                    $.ajax({
                        url: deleteAllUrl,
                        type: 'DELETE',
                        data: {
                            _token: csrfToken
                        },
                        success: function(response) {
                            alert(response.success);
                            location.reload();
                        }
                    });
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\antrian\resources\views/operator/index.blade.php ENDPATH**/ ?>