<?php $__env->startPush('style'); ?>
    <link rel="stylesheet" href="/assets/compiled/css/iconly.css">
    <link rel="stylesheet" href="/assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="./assets/compiled/css/table-datatable-jquery.css">
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/flatpickr/flatpickr.css')); ?>" />
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <section class="row mt-5">
        <div class="col-md-9">
            <div class="card">
                <div class="card-header py-5 text-center mb-5 mx-2" style="border-bottom: 4px solid rgb(151, 151, 151); ">
                    <h2 class="card-title">SMKN 2 Kudus</h2>
                    <h4 class="card-title">Antrian Pendaftaran Siswa</h4>
                </div>
                <div class="card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success" role="alert">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>
                    <?php if(session('error')): ?>
                        <div class="alert alert-danger" role="alert">
                            <?php echo e(session('error')); ?>

                        </div>
                    <?php endif; ?>
                    <div class="text-center">
                        <form action="<?php echo e(route('Siswa.create')); ?>" method="GET">
                            <button type="submit" id="ambilAntrianButton" class="btn btn-primary btn-lg">Ambil Antrian</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Modal Kartu Antrian -->
    <div class="modal fade" id="modalKartuAntrian" tabindex="-1" aria-labelledby="modalKartuAntrianLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalKartuAntrianLabel">Kartu Antrian</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div id="kartuAntrianContent"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                    <button type="button" class="btn btn-primary" id="btnCetakKartuAntrian">Cetak</button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            $('form').submit(function(event) {
                event.preventDefault();

                var $button = $('#ambilAntrianButton');
                $button.prop('disabled', true);

                $.ajax({
                    url: $(this).attr('action'),
                    type: 'POST',
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    success: function(response) {
                        $('#kartuAntrianContent').html(response.kartuAntrian);
                        $('#modalKartuAntrian').modal('show');

                        // Re-enable the button after 20 seconds
                        setTimeout(function() {
                            $button.prop('disabled', false);
                        }, 20000);
                    },
                    error: function(xhr, status, error) {
                        console.error(error);

                        // Re-enable the button immediately in case of error
                        $button.prop('disabled', false);
                    }
                });
            });

            $('#btnCetakKartuAntrian').click(function() {
                var printUrl = '<?php echo e(route('print.kasir')); ?>';
                var printWindow = window.open(printUrl, '_blank');

                $.ajax({
                    url: printUrl,
                    type: 'POST',
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        kartuAntrian: $('#kartuAntrianContent').html()
                    },
                    success: function(response) {
                        printWindow.document.write(response.kartuAntrian);

                        setTimeout(function() {
                            printWindow.print();
                        }, 1000);
                    },
                    error: function(xhr, status, error) {
                        console.error(error);
                    }
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\antrian\resources\views/siswa/index.blade.php ENDPATH**/ ?>