<?php

use App\Http\Controllers\AdminController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\ConfigurationController;
use App\Http\Controllers\OperatorController;
use App\Http\Controllers\PengumumanController;
use App\Http\Controllers\SiswaController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::group(['middleware' => 'auth:sanctum'], function () {
    Route::group(['middleware' => 'operator'], function () {
        Route::get('/operator', [OperatorController::class, 'index'])->name('Operator.dashboard');

        // Update Delete
        Route::get('/operator/antrian/{id}/edit', [OperatorController::class, 'edit'])->name('Operator.edit');
        Route::put('/operator/antrian/status/{id}', [OperatorController::class, 'updateStatus'])->name('Operator.update.status');
        Route::put('/operator/antrian/{id}', [OperatorController::class, 'update'])->name('Operator.update');
        Route::delete('/operator/antrian/{id}', [OperatorController::class, 'delete'])->name('Operator.delete');
        Route::put('/operator/antrian/status/check/{id}', [OperatorController::class, 'checked'])->name('Operator.update.status.check');
        Route::delete('/operator/antrian', [AdminController::class, 'deleteAll'])->name('Operator.delete.all');

        // Antrian
        Route::post('/operator/panggilan-antrian', [OperatorController::class, 'panggilAntrian']);
        Route::get('/operator/ambil-antrian', [SiswaController::class, 'index'])->name('Operator.ambil.antrian');
    });

    Route::group(['middleware' => 'admin'], function () {
        Route::get('/admin', [AdminController::class, 'index'])->name('Admin.dashboard');
        Route::get('/admin/monitor', [AdminController::class, 'monitor'])->name('Admin.monitor');

        // Update Delete
        Route::get('/admin/antrian/{id}/edit', [AdminController::class, 'edit'])->name('Admin.edit');
        Route::put('/admin/antrian/status/{id}', [AdminController::class, 'updateStatus'])->name('Admin.update.status');
        Route::put('/admin/antrian/status/check/{id}', [AdminController::class, 'checked'])->name('Admin.update.status.check');
        Route::put('/admin/antrian/{id}', [AdminController::class, 'update'])->name('Admin.update');
        Route::delete('/admin/antrian/{id}', [AdminController::class, 'delete'])->name('Admin.delete');
        Route::delete('/admin/antrian', [AdminController::class, 'deleteAll'])->name('Admin.delete.all');

        // Pengumuman
        Route::get('/admin/pengumuman', [PengumumanController::class, 'index'])->name('Admin.pengumuman.index');
        Route::post('/admin/pengumuman', [PengumumanController::class, 'store'])->name('Admin.pengumuman.store');
        Route::get('/admin/pengumuman/{id}/edit', [PengumumanController::class, 'edit'])->name('Admin.pengumuman.edit');
        Route::put('/admin/pengumuman/{id}', [PengumumanController::class, 'update'])->name('Admin.pengumuman.update');
        Route::delete('/admin/pengumuman/{id}', [PengumumanController::class, 'destroy'])->name('Admin.pengumuman.destroy');

        // Riwayat
        Route::get('/admin/riwayat/all', [AdminController::class, 'riwayatAll'])->name('Admin.riwayat.all');
        Route::get('/admin/riwayat/menunggu', [AdminController::class, 'riwayatTunggu'])->name('Admin.riwayat.tunggu');
        Route::get('/admin/riwayat/diproses', [AdminController::class, 'riwayatProses'])->name('Admin.riwayat.proses');
        Route::get('/admin/riwayat/selesai', [AdminController::class, 'riwayatSelesai'])->name('Admin.riwayat.selesai');

        Route::get('/get-latest-queue-data', [AdminController::class, 'getLatestQueueData'])->name('Admin.queue.latest');

        // Config
        Route::get('/admin/configuration', [ConfigurationController::class, 'edit'])->name('Admin.configuration.edit');
        Route::post('/admin/configuration', [ConfigurationController::class, 'update'])->name('admin.configuration.update');

        // User
        Route::put('/admin/users', [AdminController::class, 'user'])->name('Admin.users');
        Route::get('/admin/users', [AdminController::class, 'user'])->name('Admin.users');
        Route::get('/admin/users/create', [AdminController::class, 'create'])->name('Admin.users.create');
        Route::delete('/admin/users/{user_id}', [AdminController::class, 'destroy'])->name('Admin.users.delete');
        Route::post('/admin/users', [AdminController::class, 'store'])->name('Admin.users.store');
        Route::get('/admin/users/{user_id}/edit', [AdminController::class, 'userAdminEdit'])->name('Admin.users.edit');
        Route::put('/admin/users/{user_id}', [AdminController::class, 'adminUpdate'])->name('Admin.users.update');
    });

    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
});

Route::group(['middleware' => 'petugas'], function () {
    Route::get('/petugas', [SiswaController::class, 'petugas'])->name('Petugas.dashboard');
    Route::post('/create', [SiswaController::class, 'create'])->name('Siswa.create');
    Route::get('/queue/data', [SiswaController::class, 'getQueueData'])->name('Petugas.queue.data');
    Route::get('/petugas/queue/list', [SiswaController::class, 'list'])->name('Petugas.queue.list');
});
Route::get('/operator/get-latest-queue-data', [OperatorController::class, 'getLatestQueueData'])->name('Operator.queue.latest');
Route::get('/queue/data', [SiswaController::class, 'getQueueData'])->name('Siswa.queue.data');
Route::get('/', [SiswaController::class, 'index'])->name('Siswa.dashboard');
Route::get('/login', [AuthController::class, 'index'])->name('login');
Route::post('/login', [AuthController::class, 'login']);

Route::post('/print/kasir', [SiswaController::class, 'printKasir'])->name('print.kasir');
Route::post('/print/data/kasir', [SiswaController::class, 'printDataKasir'])->name('print.data.kasir');
