@extends('layout.app')

@push('style')
    <link rel="stylesheet" href="/assets/compiled/css/iconly.css">
    <link rel="stylesheet" href="/assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="./assets/compiled/css/table-datatable-jquery.css">
    <link rel="stylesheet" href="{{ asset('assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/vendor/libs/flatpickr/flatpickr.css') }}" />
    <style>
    #currentDate {
    font-weight: bold;
}

    .announcement {
        background-color: #f8f9fa;
        border-radius: 10px;
        padding: 20px;
        margin-top: 20px;
        border: 1px solid #ced4da;
        cursor: pointer; /* Add cursor pointer to indicate clickable */
    }
    
    .announcement:hover {
      background-color: #f1f3f5;
      transition-duration: 300ms;
    }
    
    .announcement h2 {
        font-size: 1.5rem;
        font-weight: bold;
    }
    .announcement p {
        font-size: 1.2rem;
        margin: 0;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
</style>

@endpush

@section('content')
    <section class="row">
        <div class="col-md-9">
            <div class="card">
                <div class="card-header py-5 text-center mb-5 mx-2" style="border-bottom: 4px solid rgb(151, 151, 151); ">
                    <h2 class="card-title">SMKN 2 Kudus</h2>
                    <h4 class="card-title">Antrian Pendaftaran Siswa</h4>
                </div>
                <div class="card-body">
                    <div class="text-center">
    <p>Batas Antrian Hari Ini: <strong id="queueLimit">{{ $queueLimit }}</strong></p>
    <p>Sisa Antrian Hari Ini: <strong id="remainingSlots">{{ $remainingSlots }}</strong></p>
    <p>Tanggal Hari Ini: <strong id="currentDate"></strong></p> <!-- Elemen baru untuk tanggal -->
</div>

                    <div class="announcement text-center">
                        <h2>Pengumuman</h2>
                        <p id="pengumuman">Tidak ada pengumuman</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Modal -->
    <div class="modal fade" id="pengumumanModal" tabindex="-1" aria-labelledby="pengumumanModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="pengumumanModalLabel">Pengumuman</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p id="pengumumanFull"></p>
                </div>
            </div>
        </div>
    </div>
@endsection


@push('script')
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
    // Function to fetch the latest queue data and update the UI
    function updateQueueData() {
        $.ajax({
            url: '{{ route('Siswa.queue.data') }}',
            type: 'GET',
            success: function(response) {
                $('#queueLimit').text(response.queueLimit);
                $('#remainingSlots').text(response.remainingSlots);
                if (response.pengumuman) {
                    $('#pengumuman').text(response.pengumuman.pengumuman);
                    $('#pengumumanFull').text(response.pengumuman.pengumuman);
                } else {
                    $('#pengumuman').text('Tidak ada pengumuman');
                    $('#pengumumanFull').text('Tidak ada pengumuman');
                }
            },
            error: function(xhr, status, error) {
                console.error(error);
            }
        });
    }

    // Function to display the current date
    function displayCurrentDate() {
        var today = new Date();
        var options = { year: 'numeric', month: 'long', day: 'numeric' };
        var formattedDate = today.toLocaleDateString('id-ID', options); // Format tanggal sesuai lokal Indonesia
        $('#currentDate').text(formattedDate);
    }

    setInterval(updateQueueData, 2000);

    // Initial fetch of queue data
    updateQueueData();

    // Display the current date
    displayCurrentDate();

    // Show modal on announcement click
    $('.announcement').click(function() {
        $('#pengumumanModal').modal('show');
    });
});

    </script>
@endpush

