@extends('layout.app')

@push('style')
    <link rel="stylesheet" href="/assets/compiled/css/iconly.css">
    <link rel="stylesheet" href="/assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="./assets/compiled/css/table-datatable-jquery.css">
    <link rel="stylesheet" href="{{ asset('assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/vendor/libs/flatpickr/flatpickr.css') }}" />
@endpush

@section('content')
    <section class="row mt-5">
        <div class="col-md-9">
            <div class="card">
                <div class="card-header py-5 text-center mb-5 mx-2" style="border-bottom: 4px solid rgb(151, 151, 151); ">
                    <h2 class="card-title">SMKN 2 Kudus</h2>
                    <h4 class="card-title">Antrian Pendaftaran Siswa</h4>
                </div>
                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif
                    @if (session('error'))
                        <div class="alert alert-danger" role="alert">
                            {{ session('error') }}
                        </div>
                    @endif
                    <div class="text-center">
                        <p>Batas Antrian Hari Ini: <strong id="queueLimit">{{ $queueLimit }}</strong></p>
                        <p>Sisa Antrian Hari Ini: <strong id="remainingSlots">{{ $remainingSlots }}</strong></p>
                        <form action="{{ route('Siswa.create') }}" method="GET">
                            <button type="submit" id="ambilAntrianButton" class="btn btn-primary btn-lg">Ambil Antrian</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Modal Kartu Antrian -->
    <div class="modal fade" id="modalKartuAntrian" tabindex="-1" aria-labelledby="modalKartuAntrianLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalKartuAntrianLabel">Kartu Antrian</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div id="kartuAntrianContent"></div>
                </div>
                <div class="modal-footer">
                     <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" id="btnTutupModal">Tutup</button>
                     <button type="button" class="btn btn-primary" id="btnCetakKartuAntrian">Cetak</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <!-- Vendors JS -->
    <script src="{{ asset('assets/vendor/libs/flatpickr/flatpickr.js') }}"></script>
    <script src="{{ asset('assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js') }}"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.0.3/css/buttons.dataTables.min.css">
    <script src="https://cdn.datatables.net/buttons/1.0.3/js/dataTables.buttons.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.0.3/css/buttons.dataTables.min.css">
    <script src="https://cdn.datatables.net/buttons/1.0.3/js/dataTables.buttons.min.js"></script>
    <script src="{{ asset('/vendor/datatables/buttons.server-side.js') }}"></script>
    <script>
        $(document).ready(function() {
            // Function to fetch the latest queue data and update the UI
            function updateQueueData() {
                $.ajax({
                    url: '{{ route('Siswa.queue.data') }}',
                    type: 'GET',
                    success: function(response) {
                        $('#queueLimit').text(response.queueLimit);
                        $('#remainingSlots').text(response.remainingSlots);
                    },
                    error: function(xhr, status, error) {
                        console.error(error);
                    }
                });
            }

            setInterval(updateQueueData, 2000);
            
           $('#modalKartuAntrian').on('shown.bs.modal', function () {
        // Menonaktifkan penutupan modal saat mengklik di luar modal
        $('body').on('click', function (e) {
            if ($(e.target).hasClass('modal')) {
                e.stopPropagation();
            }
        });

        // Menonaktifkan tombol "Tutup" saat modal ditampilkan
        $('#btnTutupModal').prop('disabled', true);

        // Setelah 5 detik, aktifkan kembali tombol "Tutup" dan penutupan modal saat mengklik di luar modal
        var enableCloseModal = setTimeout(function() {
            $('#btnTutupModal').prop('disabled', false);
            $('body').off('click');
        }, 5000); // 5000 milidetik (5 detik)

        // Menghapus listener saat modal ditutup sebelum 5 detik berakhir
        $('#modalKartuAntrian').on('hidden.bs.modal', function () {
            clearTimeout(enableCloseModal);
        });
    });
            $('form').submit(function(event) {
                event.preventDefault();

                var $button = $('#ambilAntrianButton');
                $button.prop('disabled', true);

                $.ajax({
                    url: $(this).attr('action'),
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        $('#kartuAntrianContent').html(response.kartuAntrian);
                        $('#modalKartuAntrian').modal('show');
                        updateQueueData(); // Update the queue data immediately after successful form submission

                        // Re-enable the button after 20 seconds
                        setTimeout(function() {
                            $button.prop('disabled', false);
                        }, 20000);
                    },
                    error: function(xhr, status, error) {
                        console.error(error);

                        // Re-enable the button immediately in case of error
                        $button.prop('disabled', false);
                    }
                });
            });

            $('#btnCetakKartuAntrian').click(function() {
                var printUrl = '{{ route('print.kasir') }}';
                var printWindow = window.open(printUrl, '_blank');

                $.ajax({
                    url: printUrl,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        kartuAntrian: $('#kartuAntrianContent').html()
                    },
                    success: function(response) {
                        printWindow.document.write(response.kartuAntrian);

                        setTimeout(function() {
                            printWindow.print();
                        }, 1000);
                    },
                    error: function(xhr, status, error) {
                        console.error(error);
                    }
                });
            });

            // Initial fetch of queue data
            updateQueueData();
        });
    </script>
@endpush
