@extends('layout.app')

@push('style')
    <link rel="stylesheet" href="{{ asset('assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/vendor/libs/flatpickr/flatpickr.css') }}" />
@endpush

@section('content')
    <div class="col-lg-8 col-md-6 mb-3">
        <div class="card">
            <div class="card-header d-flex align-items-center justify-content-between">
                <h5 class="h5">Input Data User</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('Admin.users.store') }}" method="POST" id="form-nama-user">
                    @csrf
                    <div class="form-floating form-floating-outline mb-3">
                        <input class="form-control" id="name" type="text" name="name"
                            placeholder="Masukkan Nama User" autofocus required />
                        <label for="name">Name</label>
                        <span class="text-danger name_error"></span>
                    </div>
                    <div class="form-floating form-floating-outline mb-3">
                        <input class="form-control" id="username" type="text" name="username"
                            placeholder="Masukkan Username" autofocus required />
                        <label for="name">Username</label>
                        <span class="text-danger username_error"></span>
                    </div>
                    <div class="form-floating form-floating-outline mb-3">
                        <select class="form-select" id="level" name="level" required>
                            <option value="" selected disabled>Pilih Level</option>
                            <option value="Admin">Admin</option>
                            <option value="Operator">Operator</option>
                            <option value="Petugas">Petugas</option>
                        </select>
                        <label for="level">Level</label>
                        <span class="text-danger level_error"></span>
                    </div>
                    <div class="mb-3">
                        <div class="input-group input-group-merge">
                            <div class="form-floating form-floating-outline">
                                <input type="password" class="form-control" name="password" id="password"
                                    placeholder="*****" required />
                                <label>Password</label>
                            </div>
                        </div>
                        <span class="text-danger password_error "></span>
                    </div>
                    <span class="text-danger foto_error"></span>
                    <div class="float-end">
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <!-- Vendors JS -->
    <script src="{{ asset('assets/vendor/libs/flatpickr/flatpickr.js') }}"></script>
    <script src="{{ asset('assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js') }}"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.0.3/css/buttons.dataTables.min.css">
    <script src="https://cdn.datatables.net/buttons/1.0.3/js/dataTables.buttons.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.0.3/css/buttons.dataTables.min.css">
    <script src="https://cdn.datatables.net/buttons/1.0.3/js/dataTables.buttons.min.js"></script>
    <script src="{{ asset('/vendor/datatables/buttons.server-side.js') }}"></script>
@endpush
