@extends('layout.app')

@push('style')
    <link rel="stylesheet" href="/assets/compiled/css/iconly.css">
    <link rel="stylesheet" href="/assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="./assets/compiled/css/table-datatable-jquery.css">
    <link rel="stylesheet" href="{{ asset('assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/vendor/libs/flatpickr/flatpickr.css') }}" />
@endpush

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Daftar Antrian</h4>
                </div>
                <div class="card-body">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="antrian_table" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Waktu Masuk</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($daftarAntrian as $antrian)
                                        <tr id="table_antrian">
                                            <td>{{ $antrian->queue->kuota }}</td>
                                            <td>{{ $antrian->tanggal_masuk }}</td>
                                            <td>{{ $antrian->status }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                            {{ $daftarAntrian->links('pagination::bootstrap-5') }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

     
     
@endsection

@push('script')
    <!-- Vendors JS -->
    <script src="{{ asset('assets/vendor/libs/flatpickr/flatpickr.js') }}"></script>
    <script src="{{ asset('assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js') }}"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.0.3/css/buttons.dataTables.min.css">
    <script src="https://cdn.datatables.net/buttons/1.0.3/js/dataTables.buttons.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.0.3/css/buttons.dataTables.min.css">
    <script src="https://cdn.datatables.net/buttons/1.0.3/js/dataTables.buttons.min.js"></script>
    <script src="{{ asset('/vendor/datatables/buttons.server-side.js') }}"></script>

    <script>
        $(document).ready(function() {
            $('.btn-panggil').click(function() {
                var row = $(this).closest('tr');
                var id = row.find('td:first-child').text();
                var status = row.find('td:eq(2)').text();
                var audioElement = document.createElement('audio');
                var baseUrl = "{{ url('/') }}";
                var updateUrl = baseUrl + "/admin/antrian/status/" + id;
                var csrfToken = $('meta[name="csrf-token"]').attr('content');

                if (status !== "Selesai") {
                    var msg = new SpeechSynthesisUtterance('Antrian nomor ' + id + ' menuju Admin');
                    msg.lang = 'id-ID';
                    window.speechSynthesis.speak(msg);

                    var button = $(this);

                    $.ajax({
                        url: updateUrl,
                        type: 'PUT',
                        data: {
                            _token: csrfToken,
                            status: "Diproses"
                        },
                        success: function(response) {
                            button.closest('tr').find('td:eq(2)').text("Diproses");
                        }
                    });
                }
            });

            $('.btn-selesai').click(function() {
                var row = $(this).closest('tr');
                var id = row.find('td:first-child').text();
                var status = row.find('td:eq(2)').text();
                var baseUrl = "{{ url('/') }}";
                var updateUrl = baseUrl + "/admin/antrian/status/check/" + id;
                var csrfToken = $('meta[name="csrf-token"]').attr('content');

                if (status !== "Selesai") {
                    var button = $(this);

                    $.ajax({
                        url: updateUrl,
                        type: 'PUT',
                        data: {
                            _token: csrfToken,
                            status: "Selesai"
                        },
                        success: function(response) {
                            button.closest('tr').find('td:eq(2)').text("Selesai");
                        }
                    });
                }
            });

            $('#btnHapusSemua').click(function() {
                if (confirm('Apakah Anda yakin ingin menghapus semua antrian?')) {
                    var baseUrl = "{{ url('/') }}";
                    var deleteAllUrl = baseUrl + "/admin/antrian";
                    var csrfToken = $('meta[name="csrf-token"]').attr('content');

                    $.ajax({
                        url: deleteAllUrl,
                        type: 'DELETE',
                        data: {
                            _token: csrfToken
                        },
                        success: function(response) {
                            alert(response.success);
                            location.reload();
                        }
                    });
                }
            });
        });
    </script>
@endpush
