@extends('layout.app')

@push('style')
    <link rel="stylesheet" href="{{ asset('assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/vendor/libs/flatpickr/flatpickr.css') }}" />
@endpush

@section('content')
    <div class="col-lg-8 col-md-6 mb-3">
        <div class="card">
            <div class="card-header d-flex align-items-center justify-content-between">
                <h5 class="h5">Pengumuman</h5>
            </div>
            <div class="card-body">
                @if ($pengumuman)
                    <div class="alert alert-info">
                        <strong>Pengumuman Saat Ini:</strong>
                        <p id="current-pengumuman">{{ $pengumuman->pengumuman }}</p>
                        <button type="button" class="btn btn-warning btn-edit-pengumuman" data-bs-toggle="modal"
                            data-bs-target="#editPengumumanModal" data-pengumuman="{{ $pengumuman->pengumuman }}"
                            data-id="{{ $pengumuman->id }}">
                            Edit
                        </button>
                        <form action="{{ route('Admin.pengumuman.destroy', $pengumuman->id) }}" method="POST"
                            style="display: inline-block;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger"
                                onclick="return confirm('Apakah Anda yakin ingin menghapus pengumuman ini?')">Hapus</button>
                        </form>
                    </div>
                @else
                    <form action="{{ route('Admin.pengumuman.store') }}" method="POST" id="form-pengumuman">
                        @csrf
                        <div class="form-floating form-floating-outline mb-3">
                            <textarea class="form-control" id="pengumuman" name="pengumuman" placeholder="Buat Pengumuman" rows="3" cols="50" required></textarea>
                            <label for="pengumuman">Pengumuman</label>
                            <span class="text-danger pengumuman_error"></span>
                        </div>
                        <span class="text-danger foto_error"></span>
                        <div class="float-end">
                            <button type="submit" class="btn btn-primary">Simpan</button>
                        </div>
                    </form>
                @endif
            </div>
        </div>
    </div>

    <!-- Edit Pengumuman Modal -->
    <div class="modal fade" id="editPengumumanModal" tabindex="-1" aria-labelledby="editPengumumanModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editPengumumanModalLabel">Edit Pengumuman</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="" method="POST" id="form-edit-pengumuman">
                        @csrf
                        @method('PUT')
                        <div class="form-floating form-floating-outline mb-3">
                            <textarea class="form-control" id="edit_pengumuman" name="pengumuman" placeholder="Edit Pengumuman" rows="3" cols="50" required></textarea>
                            <label for="edit_pengumuman">Pengumuman</label>
                            <span class="text-danger pengumuman_error"></span>
                        </div>
                        <div class="float-end">
                            <button type="submit" class="btn btn-primary btn-save">Simpan</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <!-- Vendors JS -->
    <script src="{{ asset('assets/vendor/libs/flatpickr/flatpickr.js') }}"></script>
    <script src="{{ asset('assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js') }}"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.0.3/css/buttons.dataTables.min.css">
    <script src="https://cdn.datatables.net/buttons/1.0.3/js/dataTables.buttons.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.0.3/css/buttons.dataTables.min.css">
    <script src="https://cdn.datatables.net/buttons/1.0.3/js/dataTables.buttons.min.js"></script>
    <script src="{{ asset('/vendor/datatables/buttons.server-side.js') }}"></script>

    <script>
        $(document).ready(function() {
            // Handle edit button click
            $('.btn-edit-pengumuman').click(function(event) {
                event.preventDefault();
                var pengumuman = $(this).data('pengumuman');
                var id = $(this).data('id');

                // Set data in modal
                $('#edit_pengumuman').val(pengumuman);
                $('#form-edit-pengumuman').attr('action', "{{ url('admin/pengumuman') }}/" + id);
            });

            // Handle save button click in modal
            $('.btn-save').click(function(event) {
                event.preventDefault();
                var form = $('#form-edit-pengumuman');
                var actionUrl = form.attr('action');
                var formData = form.serialize();

                $.ajax({
                    url: actionUrl,
                    type: 'POST',
                    data: formData,
                    success: function(response) {
                        $('#editPengumumanModal').modal('hide');
                        location.reload();
                        alert('Pengumuman berhasil diperbarui!');
                    },
                    error: function(xhr, status, error) {
                        console.error(xhr.responseText);
                        alert('Terjadi kesalahan, silakan coba lagi.');
                    }
                });
            });
        });
    </script>
@endpush
