@extends('layout.app')

@push('style')
    <link rel="stylesheet" href="/assets/compiled/css/iconly.css">
    <link rel="stylesheet" href="/assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="./assets/compiled/css/table-datatable-jquery.css">
    <link rel="stylesheet" href="{{ asset('assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/vendor/libs/flatpickr/flatpickr.css') }}" />
    <style>
    body {
        overflow: hidden;
    }
        .content {
            margin-top: -12rem;
            margin-left: -14rem;
            transform: scale(0.70);
            overflow: hidden;
        }

        .stats-icon {
            margin: 10px;
            color: #000000;
            align-items: center;
            justify-content: center;
        }

        .title {
            margin-left: 20px;
            font-size: 2rem;
            color: #333333;
        }

        .card {
            background-color: rgba(45, 59, 255, 0.7);
            color: #000000;
            height: 125vh;
            box-shadow: rgba(50, 50, 93, 0.25) 0px 13px 27px -5px, rgba(0, 0, 0, 0.3) 0px 8px 16px -8px;
        }

        .font-extrabold {
            font-size: 4rem;
            color: #000000;
        }

        .font-bold {
            font-size: 3.5rem;
        }

        .font-extrabold-large {
            font-size: 8rem;
            color: #000000;
        }

        .text-muted {
            color: #000000 !important;
        }

        #antrianSekarang {
            transform: scale(5);
            margin-top: 10rem;
        }

        .section-title {
            font-size: 3rem;
            margin-top: -20px;
            margin-bottom: 10px;
            color: #000000;
        }

        @media (max-width: 768px) {
            .font-extrabold {
                font-size: 3rem;
            }

            .font-extrabold-large {
                font-size: 5rem;
            }

            .stats-icon {
                font-size: 2rem;
            }
        }

        .clock {
            font-size: 3rem;
            color: #000000;
        }

        .running-text {
            width: 100%;
            overflow: hidden;
            white-space: nowrap;
            box-sizing: border-box;
        }

        .running-text p {
            display: inline-block;
            padding-left: 100%;
            animation: marquee 15s linear infinite;
        }

        @keyframes marquee {
            0% {
                transform: translate(0, 0);
            }

            100% {
                transform: translate(-100%, 0);
            }
        }

        .queue-card {
            background-color: rgba(255, 255, 255, 0.8);
            border: none;
        }

        .queue-card h1,
        .queue-card h6 {
            color: #000000;
        }

        .queue-card h1 {
            font-size: 5rem;
            margin: 0;
        }

        .queue-card h6 {
            font-size: 2rem;
            margin: 0;
        }

        .queue-card-large {
            font-size: 9rem;
        }
    </style>
@endpush

@section('content')
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="card p-5">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <div class="d-flex align-items-center">
                            <a class="d-flex" href="/admin">
                                <img src="/assets/img/cropped-SMKN-2-Kudus.png" alt="Bank Logo" style="height: 80px;">
                                <h3 class="title text-white mt-3">PPDB SMKN 2 KUDUS</h3>
                            </a>
                        </div>
                        <div class="clock text-white" id="clock">00:00:00</div>
                    </div>
                    <div class="section-title text-center text-white">Monitor Antrian</div>
                    <div class="row text-center">
                        <div class="col-md-6 mb-4">
                            <div class="card queue-card h-100">
                                <div class="card-body">
                                    <h6>Antrian Sekarang</h6>
                                    <h1 id="antrianSekarang" class="font-extrabold-large">-</h1>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="row text-center">
                                <div class="col-md-12 mb-4">
                                    <div class="card queue-card h-100">
                                        <div class="card-body">
                                            <h6>Antrian Selanjutnya</h6>
                                            <h1 id="antrianSelanjutnya" class="font-extrabold">-</h1>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12 mb-4">
                                    <div class="card queue-card h-100">
                                        <div class="card-body">
                                            <h6>Antrian Selesai</h6>
                                            <h1 id="antrianSelesai" class="font-extrabold">-</h1>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12 mb-4">
                                    <div class="card queue-card h-100">
                                        <div class="card-body">
                                            <h6>Total Antrian</h6>
                                            <h1 id="latestQueue" class="font-extrabold">-</h1>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @for ($i = 1; $i <= 13; $i++)
                            <div class="col-md-2 mt-3">
                                <div class="card queue-card h-100">
                                    <div class="card-body">
                                        <h6>Operator {{ $i }}</h6>
                                        <h1 id="operator{{ $i }}" class="font-extrabold">-</h1>
                                    </div>
                                </div>
                            </div>
                        @endfor
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('script')
    <script src="{{ asset('assets/vendor/libs/flatpickr/flatpickr.js') }}"></script>
    <script src="{{ asset('assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js') }}"></script>
<script src="https://cdn.datatables.net/buttons/1.0.3/js/dataTables.buttons.min.js"></script>
<script src="{{ asset('/vendor/datatables/buttons.server-side.js') }}"></script>

<script>
    $(document).ready(function() {
        var lastQueue = ''; // Deklarasi lastQueue di luar fungsi updateQueueData

        function updateClock() {
            var now = new Date();
            var days = ['Minggu', 'Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu'];
            var day = days[now.getDay()];
            var hours = String(now.getHours()).padStart(2, '0');
            var minutes = String(now.getMinutes()).padStart(2, '0');
            var seconds = String(now.getSeconds()).padStart(2, '0');
            $('#clock').text(`${day}, ${hours}:${minutes}:${seconds}`);
        }
        setInterval(updateClock, 1000);

        function updateQueueData() {
            $.ajax({
                url: '{{ route('Admin.queue.latest') }}',
                type: 'GET',
                success: function(response) {
                    $('#latestQueue').text(response.latestQueue ? response.latestQueue.kuota : '-');
                    var currentQueue = response.antrianSekarang && response.antrianSekarang.queue ? response.antrianSekarang.queue.kuota : '-';
                    $('#antrianSekarang').text(currentQueue);
                    $('#antrianSelanjutnya').text(response.antrianSelanjutnya && response.antrianSelanjutnya.queue ? response.antrianSelanjutnya.queue.kuota : '-');
                    $('#antrianSelesai').text(response.antrianSelesai && response.antrianSelesai.queue ? response.antrianSelesai.queue.kuota : '-');

                    for (let i = 1; i <= 13; i++) {
                        var operator = response['operator' + i];
                        var queueNumber = operator && operator.queue ? operator.queue.kuota : '-';
                        $('#operator' + i).text(queueNumber);
                    }

                    if (lastQueue !== currentQueue && currentQueue !== '-') {
                        announceQueue(response.antrianSekarang);
                        lastQueue = currentQueue;
                    }
                },
                error: function(xhr, status, error) {
                    console.error('AJAX error:', error);
                }
            });
        }

        function announceQueue(antrian) {
            if (antrian && antrian.queue) {
                var operatorFullName = antrian.operator_full_name || ''; // Berikan nilai default jika operator_full_name tidak ada
                var queueNumber = antrian.queue.kuota;
                var msg = new SpeechSynthesisUtterance('Antrian nomor ' + queueNumber + ' menuju ' +
                                operatorFullName);
                msg.lang = 'id-ID';
                window.speechSynthesis.cancel();
                window.speechSynthesis.speak(msg);
            }
        }

        setInterval(updateQueueData, 2000);

        // Simpan informasi suara terakhir ke local storage
        window.addEventListener('beforeunload', function() {
            localStorage.setItem('lastQueue', lastQueue);
        });

        // Muat kembali informasi suara terakhir dari local storage
        window.addEventListener('load', function() {
            var storedQueue = localStorage.getItem('lastQueue');
            if (storedQueue) {
                lastQueue = storedQueue;
            }
        });
    });
</script>
@endpush
