declare type Context = import("./Context").Context;
/**
 * Used internally to setup a new Context
 */
export declare function onContextInit(cb: (ctx: Context) => void): void;
/**
 * Invoke any classes which need to also be initialized when a new context is created.
 */
export declare function initializeContext(ctx: Context): void;
/**
 * Used internally to tear down a Context
 */
export declare function onContextClose(cb: (ctx: Context) => void): void;
export declare function closeContext(ctx: Context): void;
export {};
