import { TAudioBufferSourceNodeConstructor } from './audio-buffer-source-node-constructor';
import { TAudioBufferSourceNodeRendererFactory } from './audio-buffer-source-node-renderer-factory';
import { TAudioNodeConstructor } from './audio-node-constructor';
import { TAudioParamFactory } from './audio-param-factory';
import { TGetNativeContextFunction } from './get-native-context-function';
import { TInvalidStateErrorFactory } from './invalid-state-error-factory';
import { TIsNativeOfflineAudioContextFunction } from './is-native-offline-audio-context-function';
import { TNativeAudioBufferSourceNodeFactory } from './native-audio-buffer-source-node-factory';
import { TWrapEventListenerFunction } from './wrap-event-listener-function';

export type TAudioBufferSourceNodeConstructorFactory = (
    audioNodeConstructor: TAudioNodeConstructor,
    createAudioBufferSourceNodeRenderer: TAudioBufferSourceNodeRendererFactory,
    createAudioParam: TAudioParamFactory,
    createInvalidStateError: TInvalidStateErrorFactory,
    createNativeAudioBufferSourceNode: TNativeAudioBufferSourceNodeFactory,
    getNativeContext: TGetNativeContextFunction,
    isNativeOfflineAudioContext: TIsNativeOfflineAudioContextFunction,
    wrapEventListener: TWrapEventListenerFunction
) => TAudioBufferSourceNodeConstructor;
