import { IAudioNode, IAudioWorkletProcessor, IAudioWorkletProcessorConstructor } from './interfaces';
import { TAudioNodeConnectionsStore, TAudioNodeStore, TAudioParamConnectionsStore, TAudioParamStore, TContext, TContextStore, TCycleCounters, TInternalStateEventListener, TNativeAudioWorkletNode, TNativeContext } from './types';
export declare const ACTIVE_AUDIO_NODE_STORE: WeakSet<IAudioNode<TContext>>;
export declare const AUDIO_NODE_CONNECTIONS_STORE: TAudioNodeConnectionsStore;
export declare const AUDIO_NODE_STORE: TAudioNodeStore;
export declare const AUDIO_PARAM_CONNECTIONS_STORE: TAudioParamConnectionsStore;
export declare const AUDIO_PARAM_STORE: TAudioParamStore;
export declare const CONTEXT_STORE: TContextStore;
export declare const EVENT_LISTENERS: WeakMap<IAudioNode<TContext>, Set<TInternalStateEventListener>>;
export declare const CYCLE_COUNTERS: TCycleCounters;
export declare const NODE_NAME_TO_PROCESSOR_CONSTRUCTOR_MAPS: WeakMap<TNativeContext, Map<string, IAudioWorkletProcessorConstructor>>;
export declare const NODE_TO_PROCESSOR_MAPS: WeakMap<TNativeContext, WeakMap<TNativeAudioWorkletNode, Promise<IAudioWorkletProcessor>>>;
//# sourceMappingURL=globals.d.ts.map