<?php

namespace Database\Seeders;

use App\Models\Queue;
use App\Models\QueueLog;
use Carbon\Carbon;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class QueueSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        // Loop through 1 to 150 to create 150 Queue entries
        for ($i = 1; $i <= 150; $i++) {
            // Create a Queue entry with the current value of $i as the kuota
            $queue = Queue::create([
                'tanggal_buka' => now()->toDateString(),
                'tanggal_tutup' => null,
                'kuota' => $i,
            ]);

            // Create a corresponding QueueLog entry
            QueueLog::create([
                'queue_id' => $queue->id,
                'status' => 'Menunggu',
                'tanggal_masuk' => now(),
            ]);
        }
    }
}
