<?php

namespace Database\Factories;

use App\Models\Queue;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Queue>
 */
class QueueFactory extends Factory
{
    protected $model = Queue::class;

    public function definition()
    {
        return [
            'tanggal_buka' => now()->toDateString(),
            'tanggal_tutup' => null,
            'kuota' => $this->faker->numberBetween(1, 150)
        ];
    }
}
