<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class QueueLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'siswa_id', 'queue_id', 'user_id',  'status', 'tanggal_masuk', 'tanggal_diproses', 'tanggal_selesai'
    ];

    public function queue()
    {
        return $this->belongsTo(Queue::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    protected static function boot()
    {
        parent::boot();

        static::deleting(function ($queueLog) {
            $queueLog->queue->delete();
        });
    }
}
