<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Models\Siswa;

class TambahDataSiswa implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $siswaData;

    /**
     * Create a new job instance.
     *
     * @param array $siswaData
     * @return void
     */
    public function __construct($siswaData)
    {
        // Pastikan $siswaData adalah array sebelum disimpan
        $this->siswaData = is_array($siswaData) ? $siswaData : [];
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        // Tambahkan data siswa menggunakan atribut yang sesuai
        Siswa::create($this->siswaData);
    }
}
