<?php

namespace App\Http\Controllers;

use App\Models\Pengumuman;
use Illuminate\Http\Request;

class PengumumanController extends Controller
{
    public function index()
    {
        $pengumuman = Pengumuman::first();
        return view('admin.pengumuman.index', compact('pengumuman'));
    }

    public function store(Request $request)
    {
        // Hapus pengumuman yang ada sebelumnya
        Pengumuman::truncate();

        // Buat pengumuman baru
        Pengumuman::create($request->all());

        return redirect()->route('Admin.pengumuman.index')->with('success', 'Pengumuman berhasil dibuat.');
    }

    public function edit($id)
    {
        $pengumuman = Pengumuman::findOrFail($id);

        $data = [
            'pengumuman' => $pengumuman->pengumuman,
        ];

        return response()->json($data);
    }

    public function update(Request $request, $id)
    {
        $pengumuman = Pengumuman::findOrFail($id);
        $pengumuman->update($request->all());

        return redirect()->route('Admin.pengumuman.index')->with('success', 'Pengumuman berhasil diperbarui.');
    }

    public function destroy($id)
    {
        $pengumuman = Pengumuman::findOrFail($id);
        $pengumuman->delete();

        return redirect()->route('Admin.pengumuman.index')->with('success', 'Pengumuman berhasil dihapus.');
    }
}
