<?php

namespace App\Http\Controllers;

use App\Models\Queue;
use App\Models\QueueLog;
use Carbon\Carbon;
use Illuminate\Http\Request;

class OperatorController extends Controller
{
    public function index()
    {
        $daftarAntrian = QueueLog::with('queue')
            ->select('queue_logs.*')
            ->paginate(10);

        $loggedInOperator = session('loggedInOperator');

        return view("operator.index", compact('daftarAntrian', 'loggedInOperator'));
    }

    public function panggilAntrian()
    {
        $queue = Queue::where('kuota', '!=', 0)->first();

        if (!$queue) {
            return response()->json(['message' => 'Antrian tidak tersedia'], 404);
        }

        foreach ($queue->queueLogs as $queueLog) {
            $queueLog->status = 'Diproses';
            $queueLog->save();
        }

        return response()->json($queue);
    }

    public function getLatestQueueData()
    {
        $latestQueue = Queue::latest()->first();
        $daftarAntrian = QueueLog::with('queue')->get(); // Mengambil semua data antrian

        return response()->json([
            'latestQueue' => $latestQueue,
            'daftarAntrian' => $daftarAntrian, // Mengirim semua data antrian dalam respons
        ]);
    }


    public function edit($id)
    {
        $antrian = QueueLog::findOrFail($id);
        $nama_antrian = $antrian->queue->nama_antrian;

        return response()->json([
            'id' => $antrian->id,
            'nama_antrian' => $nama_antrian,
            'status' => $antrian->status,
        ]);
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'status' => 'required|in:Menunggu,Diproses,Selesai',
            'nama_antrian' => 'required|string|max:255',
        ]);

        $antrian = QueueLog::findOrFail($id);
        $antrian->status = $request->status;
        $antrian->save();

        // Perbarui nama_antrian jika ada dalam request
        if ($request->has('nama_antrian')) {
            $antrian->queue->nama_antrian = $request->nama_antrian;
            $antrian->queue->save();
        }

        return redirect()->route('Operator.dashboard')->with('success', 'Data antrian berhasil diperbarui.');
    }


    public function updateStatus($kuota)
    {
        $operator = auth()->user();
        $queueLog = QueueLog::whereHas('queue', function ($query) use ($kuota) {
            $query->where('kuota', $kuota);
        })->first();

        if (!$queueLog) {
            return response()->json([
                'message' => 'No query results for model QueueLog with kuota ' . $kuota,
            ], 404);
        }

        // Memperbarui status antrian
        $queueLog->status = 'Diproses';
        $queueLog->tanggal_diproses = now();
        $queueLog->user_id = $operator->id;
        $queueLog->save();

        return response()->json([
            'message' => 'Status updated successfully for QueueLog with kuota ' . $kuota,
            'queueLog' => $queueLog,
        ]);
    }

    public function checked($kuota)
    {
        // Mendapatkan instance dari model QueueLog berdasarkan kuota
        $queueLog = QueueLog::whereHas('queue', function ($query) use ($kuota) {
            $query->where('kuota', $kuota);
        })->first();

        if (!$queueLog) {
            return response()->json([
                'message' => 'No query results for model QueueLog with kuota ' . $kuota,
            ], 404);
        }

        // Memperbarui status antrian
        $queueLog->status = 'Selesai';
        $queueLog->tanggal_selesai = now();
        $queueLog->save();

        // Anda bisa mengembalikan respons JSON yang sesuai, misalnya, dengan data antrian yang telah diperbarui
        return response()->json([
            'message' => 'Status updated successfully for QueueLog with kuota ' . $kuota,
            'queueLog' => $queueLog,
            // Anda juga bisa mengirim data lain yang diperlukan sebagai respons JSON
        ]);
    }


    public function delete($id)
    {
        $queue = Queue::findOrFail($id);
        $antrian = QueueLog::with('queue')
            ->select('queue_logs.*')
            ->paginate(10);

        Queue::count() - 1;

        $antrian->delete();
        $queue->delete();
        return redirect()->route('Operator.dashboard')->with('success', 'Data antrian berhasil dihapus.');
    }
}
