<?php

namespace App\Http\Controllers;

use App\Models\Configuration;
use Illuminate\Http\Request;

class ConfigurationController extends Controller
{
    public function edit()
    {
        $queueLimit = Configuration::where('key', 'queue_limit')->value('value');
        return view('admin.configuration.edit', compact('queueLimit'));
    }

    public function update(Request $request)
    {
        $request->validate([
            'queue_limit' => 'required|integer'
        ]);

        Configuration::where('key', 'queue_limit')->update(['value' => $request->queue_limit]);

        return redirect()->route('Admin.configuration.edit')->with('success', 'Queue limit updated successfully.');
    }
}
