<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Siswa;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

class AuthController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth')->except(['index', 'login', 'siswa.dashboard']);
    }

    public function index()
    {
        return view('login.index');
    }

    public function login(Request $request)
    {
        $username = $request->input('username');
        $password = $request->input('password');

        $user = User::where('username', $username)->first();

        if (!$user) {
            return redirect('login')->with('error', 'Invalid credentials.');
        }

        if ($user->password !== $password) {
            return redirect('login')->with('error', 'Username atau Password Salah');
        }

        Auth::login($user);

        switch ($user->level) {
            case 'Admin':
                return redirect()->route('Admin.dashboard');
                break;
            case 'Operator':
                $operator = Auth::user(); 
                session(['loggedInOperator' => $operator->name]);
                return redirect()->route('Operator.dashboard');
                break;
                case 'Petugas':
                    return redirect()->route('Petugas.dashboard');
            default:
                return redirect()->intended('/');
        }
    }

    public function logout(Request $request)
    {
        Auth::guard('web')->logout();

        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return redirect('/login');
    }
}
