<?php $__env->startSection('layout'); ?>

    <link rel="stylesheet" href="/assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="/assets/compiled/css/table-datatable-jquery.css">



    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>Data Siswa Aku Jurnal</h4>
                    <div class="d-flex justify-content-between align-items-center gap-3">
                        <button class="btn btn-primary d-flex justify-content-center align-items-center" data-bs-toggle="modal" data-bs-target="#aksiLainnyaModal">
                            <i class="bi bi-three-dots-vertical mb-2 me-md-1"></i>
                            <small class="d-none d-md-block">Aksi Lainnya</small>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive datatable-minimal">
                        <table class="table" id="table2">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>NIS</th>
                                    <th>Nama</th>
                                    <th>Kelas</th>
                                    <th>Gender</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $siswas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($i + 1); ?></td>
                                        <td><?php echo e($item->nis); ?></td>
                                        <td><?php echo e($item->nama); ?></td>
                                        <td><?php echo e($item->kelas->kelas); ?></td>
                                        <td><?php echo e($item->gender); ?></td>
                                        <td>
                                            <div class="d-flex justify-content-start align-items-center gap-2">
                                                <button class="btn btn-light-primary" data-bs-toggle="modal"
                                                    data-bs-target="#editBarangModal" onclick="edit(<?php echo e($item->id); ?>)">
                                                    <i class="bi bi-pencil-fill mb-2"></i>
                                                </button>
                                            <form method="POST" action="<?php echo e(url('siswa/' . $item->id)); ?>"
                                                    data-bs-toggle="modal" id="delete_siswa_form_<?php echo e($item->id); ?>"
                                                    onsubmit="confirmSubmit(event, <?php echo e($item->id); ?>)"
                                                    data-bs-target="#border-less">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-light-danger">
                                                        <i class="bi bi-trash-fill mb-2"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="/assets/extensions/jquery/jquery.min.js"></script>
    <script src="/assets/extensions/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="/assets/extensions/datatables.net-bs5/js/dataTables.bootstrap5.min.js"></script>
    <script src="/assets/static/js/pages/datatables.js"></script>


    <?php echo $__env->make('Components.Siswa.create_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('Components.Siswa.edit_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('Components.Siswa.delete_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('Components.Siswa.import_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('Components.Siswa.other_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    
    <script>
        async function NISRegex(element_id){
            var value = $(element_id).val().replace(/\D/g, '');
            if (value.length > 4) value = value.slice(0, 4);
            $(element_id).val(value);
        }
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('Layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\AhmadBasikal\Projects\aku_jurnal\resources\views/Siswa/siswa.blade.php ENDPATH**/ ?>