<?php $__env->startSection('layout'); ?>

    <link rel="stylesheet" href="/assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="/assets/compiled/css/table-datatable-jquery.css">
    <link rel="stylesheet" href="/assets/extensions/filepond/filepond.css">


    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('adminOnly')): ?>
                        <h4>Data Jurnal Guru</h4>
                    <?php else: ?>
                        <h4>Data Jurnal Saya</h4>
                    <?php endif; ?>
                    <div class="d-flex justify-content-between align-items-center gap-3">
                        <button class="btn btn-primary d-flex justify-content-center align-items-center" data-bs-toggle="modal" data-bs-target="#aksiLainnyaModal">
                            <i class="bi bi-three-dots-vertical mb-2 me-md-1"></i>
                            <small class="d-none d-md-block">Aksi Lainnya</small>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive datatable-minimal">
                        <table class="table" id="table2">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('adminOnly')): ?>
                                        <th>Guru</th>
                                    <?php endif; ?>
                                    <th>Kelas</th>
                                    <th>Mapel</th>
                                    <th>Jam Pembelajaran</th>
                                    <th>Jurnal</th>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('guruOnly')): ?>
                                    <th>Action</th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $jurnals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($i + 1); ?></td>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('adminOnly')): ?>
                                            <td><?php echo e($item->user->nama_lengkap); ?></td>
                                        <?php endif; ?>
                                        <td><?php echo e($item->kelas->kelas); ?></td>
                                        <td><?php echo e($item->mapel->mapel); ?></td>
                                        <td><?php echo e($item->jam_ke_start); ?> <?php echo e($item->jam_ke_end ? "- ". $item->jam_ke_end : ""); ?></td>
                                        <td>
                                            <ul>
                                                <?php $__currentLoopData = $item->jurnal; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $jurInd): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li><?php echo e($jurInd); ?></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </td>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('guruOnly')): ?>
                                        <td>
                                            <div class="d-flex justify-content-start align-items-center gap-2">
                                                <button class="btn btn-light-primary" data-bs-toggle="modal"
                                                    data-bs-target="#editJurnalModal" onclick="edit(<?php echo e($item->id); ?>)">
                                                    <i class="bi bi-pencil-fill mb-2"></i>
                                                </button>
                                            <form method="POST" action="<?php echo e(url('jurnal/' . $item->id)); ?>"
                                                    data-bs-toggle="modal" id="delete_siswa_form_<?php echo e($item->id); ?>"
                                                    onsubmit="confirmSubmit(event, <?php echo e($item->id); ?>)"
                                                    data-bs-target="#border-less">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-light-danger">
                                                        <i class="bi bi-trash-fill mb-2"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                        <?php endif; ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="/assets/extensions/jquery/jquery.min.js"></script>
    <script src="/assets/extensions/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="/assets/extensions/datatables.net-bs5/js/dataTables.bootstrap5.min.js"></script>
    <script src="/assets/static/js/pages/datatables.js"></script>
    <script src="/assets/extensions/filepond/filepond.js"></script>
    <script src="/assets/static/js/pages/filepond.js"></script>


    <?php echo $__env->make('Components.Jurnal.create_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('Components.Jurnal.edit_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('Components.Jurnal.delete_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('Components.Jurnal.import_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('Components.Jurnal.other_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('Layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\aku_jurnal\resources\views/Jurnal/jurnal.blade.php ENDPATH**/ ?>