<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($title); ?> | Aku Jurnal</title>

    <link rel="stylesheet" href="/assets/compiled/css/app.css">
    <link rel="stylesheet" href="/assets/compiled/css/custom.css">
    <link rel="stylesheet" href="/assets/extensions/toastify-js/src/toastify.css">
</head>

<body>
    <script src="/assets/static/js/initTheme.js"></script>
    <div id="app">
        <div id="sidebar">
            <div class="sidebar-wrapper active">
                <div class="sidebar-header position-relative">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="d-flex justify-content-start gap-3 align-items-center">
                            <i class="bi bi-receipt mb-3 fs-5"></i>
                            <h1 class="fs-5 m-0">Aku Jurnal</h1>
                        </div>
                        <div class="sidebar-toggler mb-1">
                            <span class="sidebar-hide d-xl-none d-block">
                                <i class="bi bi-x-circle-fill text-success"></i>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="sidebar-menu">
                    <ul class="menu">
                        <li class="sidebar-item <?php echo e(Request::is('/') ? 'active' : ''); ?>">
                            <a href="/" class='sidebar-link'>
                                <i class="bi bi-grid-fill"></i>
                                <span>Dashboard</span>
                            </a>
                        </li>


                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('adminOnly')): ?>
                        <li
                            class="sidebar-item has-sub <?php echo e(Request::is('guru') || Request::is('mapel') || Request::is('siswa') ? 'active' : ''); ?>">
                            <a href="#" class='sidebar-link'>
                                <i class="bi bi-database-fill-gear"></i>
                                <span>Master Data</span>
                            </a>
                            <ul class="submenu ">
                                <li class="submenu-item <?php echo e(Request::is('guru') ? 'active' : ''); ?> ">
                                    <a href="/guru" class="submenu-link">Data Guru</a>
                                </li>
                                <li class="submenu-item <?php echo e(Request::is('mapel') ? 'active' : ''); ?> ">
                                    <a href="/mapel" class="submenu-link">Data Mapel</a>
                                </li>
                                <li class="submenu-item <?php echo e(Request::is('siswa') ? 'active' : ''); ?> ">
                                    <a href="/siswa" class="submenu-link">Data Siswa</a>
                                </li>
                            </ul>
                        </li>
                        <?php endif; ?>

                        <li class="sidebar-item <?php echo e(Request::is('jurnal') ? 'active' : ''); ?>">
                            <a href="/jurnal" class='sidebar-link'>
                                <i class="bi bi-receipt-cutoff"></i>
                                <span>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('adminOnly')): ?>
                                        Jurnal Guru
                                    <?php else: ?>
                                        Jurnal Saya
                                    <?php endif; ?>
                                </span>
                            </a>
                        </li>

                        
                        <li class="sidebar-item position-fixed" style="bottom: 1em; cursor : default;">
                            <a href="https://github.com/dendik-creation" target="_blank" class="sidebar-link fs-3 mb-3">
                                <i class="bi bi-github"></i>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div id="main">
            <header class="mb-3 d-flex justify-content-between align-items-center">
                <a href="#" class="burger-btn w-25 d-block d-xl-none">
                    <i class="bi bi-justify fs-3"></i>
                </a>
                <div class="btn-group d-block d-xl-none">
                    <div class="dropdown">
                        <button type="button"
                            class="btn btn-sm dropdown-toggle d-flex justify-content-center align-items-center"
                            data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <div class="avatar bg-success me-2">
                                <img src="/assets/compiled/jpg/2.jpg" alt="" srcset="">
                                <span class="avatar-status bg-success"></span>
                            </div>
                            <span class="me-1 d-md-block d-none">Halo, <?php echo e(auth()->user()->nama_lengkap); ?></span>
                        </button>
                        <div class="dropdown-menu me-3">
                            <button data-bs-toggle="modal" data-bs-target="#border-less-logout" type="button"
                                class="dropdown-item mb-2 d-flex justify-content-start align-items-center">
                                <i class="bi bi-box-arrow-right mb-2 me-2"></i>
                                <span>Logout</span>
                            </button>
                        </div>
                    </div>
                </div>
            </header>
            <div class="page-heading d-flex justify-content-between align-items-center">
                <h3><?php echo e($title); ?></h3>
                <div class="btn-group d-none d-xl-block">
                    <div class="dropdown">
                        <button type="button"
                            class="btn btn-sm dropdown-toggle d-flex justify-content-center align-items-center"
                            data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <div class="avatar bg-success me-2">
                                <img src="/assets/compiled/jpg/2.jpg" alt="" srcset="">
                                <span class="avatar-status bg-success"></span>
                            </div>
                            <span class="me-1 d-md-block d-none">Halo, <?php echo e(auth()->user()->nama_lengkap); ?></span>
                        </button>
                        <div class="dropdown-menu me-3">
                            <button data-bs-toggle="modal" data-bs-target="#border-less-logout" type="button"
                                class="dropdown-item mb-2 d-flex justify-content-start align-items-center">
                                <i class="bi bi-box-arrow-right mb-2 me-2"></i>
                                <span>Logout</span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="page-content">
                <?php echo $__env->make('Components.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php echo $__env->make('Components.logout_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php echo $__env->yieldContent('layout'); ?>
            </div>
        </div>
    </div>

    <script src="/assets/compiled/js/app.js"></script>
    <script src="/assets/extensions/toastify-js/src/toastify.js"></script>
    <script src="/assets/static/js/components/dark.js"></script>
    <script src="/assets/extensions/jquery/jquery.min.js"></script>

    <script>
        if (localStorage.getItem('theme') == 'dark') {
            localStorage.setItem('theme', 'light');
        }
    </script>
</body>

</html>
<?php /**PATH /home/zona4001/public_html/aku_jurnal/resources/views/Layout/layout.blade.php ENDPATH**/ ?>