<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Aku Jurnal</title>
    <link rel="stylesheet" href="./assets/compiled/css/app.css">
    <link rel="stylesheet" href="./assets/compiled/css/app-dark.css">
    <link rel="stylesheet" href="./assets/compiled/css/custom.css">
    <link rel="stylesheet" href="./assets/compiled/css/auth.css">
    <link rel="stylesheet" href="/assets/extensions/toastify-js/src/toastify.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
    <style>
        .ahmadbasikal {
            height: 100vh !important;
            animation: showUp 3s ease-out forwards;
        }

        @keyframes showUp {
            0% {
                opacity: 0;
                transform: translateY(-50vw)
            }

            100% {
                opacity: 1;
                transform: translateX(0)
            }
        }


        .sample-slider .swiper-wrapper {
            transition-timing-function: linear;
        }

        .swiper {
            width: 600px;
            height: 600px;
            position: absolute;
            left: 50%;
            top: 50%;
            margin-left: -300px;
            margin-top: -300px;
        }

        .swiper-slide img {
            width: 100%;
            height: 600px;
            object-fit: fill;
            object-position: center;
        }
    </style>
</head>

<body>
    <script src="assets/static/js/initTheme.js"></script>
    <div id="auth">
        <div class="row h-100">
            <div class="col-lg-5 col-12">
                <div id="auth-left">
                    <h1 class="auth-title">
                        <i class="bi bi-receipt"></i>
                        <span class="fs-1">Aku Jurnal</span>
                    </h1>
                    <p class="auth-subtitle mb-5">Log in untuk akses Dashboard</p>

                    <div class="mb-5">
                        <?php echo $__env->make('Components.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <form action="<?php echo e(url('/login')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="form-group position-relative has-icon-left mb-4">
                            <input type="text" autofocus required class="form-control form-control-xl" name="nip"
                                id="nip" placeholder="NIP" autocomplete="off" value="<?php echo e(Session::get('nip')); ?>">
                            <div class="form-control-icon">
                                <i class="bi bi-person"></i>
                            </div>
                        </div>
                        <div class="form-group position-relative has-icon-left mb-4">
                            <input type="password" required class="form-control form-control-xl" name="password"
                                id="password" placeholder="Password">
                            <div class="form-control-icon">
                                <i class="bi bi-shield-lock"></i>
                            </div>
                        </div>
                        <button class="btn btn-primary btn-block btn-lg shadow-lg mt-5">Log in</button>
                    </form>
                </div>
            </div>
            <div class="col-lg-7 d-none bg-success d-lg-block">
                <div id="auth-right">
                    <div class="w-100 h-100">
                        <div class="ahmadbasikal">
                            <div class="swiper sample-slider">
                                <div class="swiper-wrapper">
                                    <div class="swiper-slide"><img src="/assets/compiled/jpg/login/1.jpeg"></div>
                                    <div class="swiper-slide"><img src="/assets/compiled/jpg/login/2.jpeg"></div>
                                    <div class="swiper-slide"><img src="/assets/compiled/jpg/login/3.jpeg"></div>
                                    <div class="swiper-slide"><img src="/assets/compiled/jpg/login/4.jpeg"></div>
                                    <div class="swiper-slide"><img src="/assets/compiled/jpg/login/5.jpeg"></div>
                                    <div class="swiper-slide"><img src="/assets/compiled/jpg/login/6.jpeg"></div>
                                    <div class="swiper-slide"><img src="/assets/compiled/jpg/login/7.jpeg"></div>
                                    <div class="swiper-slide"><img src="/assets/compiled/jpg/login/8.jpeg"></div>
                                    <div class="swiper-slide"><img src="/assets/compiled/jpg/login/9.jpeg"></div>
                                    <div class="swiper-slide"><img src="/assets/compiled/jpg/login/10.png"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <script>
        setTimeout(() => {
            const swiper = new Swiper('.sample-slider', {
                loop: true,
                effect: "cube",
                autoplay: {
                    delay: 0,
                    disableOnInteraction: false,
                },
                speed: 2000,
            })
        }, 200);
    </script>
</body>

</html>
<?php /**PATH C:\laragon\www\aku_jurnal\resources\views/Auth/login.blade.php ENDPATH**/ ?>