<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title><?php echo e($data['title']); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous" />

    <style>
        * {
            font-family: "Calibri", sans-serif;
        }

        .kob-instansi {
            line-height: 20px;
        }

        .icon-dimension {
            width: 90px;
            height: 90px;
        }

        .icon-padding {
            padding: 0.6em;
        }

        th {
            vertical-align: middle;
        }
    </style>
</head>

<body class="bg-white">
    <div class="h-100 w-100">
        <div class="mx-5 mt-3">
            <!-- KOB SURAD -->
            <div class="d-flex mb-3 justify-content-between align-items-center border border-black">
                <div class="border border-black icon-padding border-top-0 border-start-0 border-bottom-0">
                    <img src="<?php echo e(url('/img/skada-icon.png')); ?>" class="icon-dimension" alt="" />
                </div>
                <div class="text-center">
                    <div class="d-flex flex-column">
                        <div class="d-flex flex-column">
                            <span class="fs-5 kob-instansi">PEMERINTAH PROVINSI JAWA TENGAH</span>
                            <span class="fs-5 kob-instansi">SEKERTARIAT BADAN KOORDINASI PENYULUHAN</span>
                            <span class="fs-5 kob-instansi">KEBAGIAN PANGAN SODAP</span>
                        </div>
                        <div class="d-flex flex-column">
                            <span class="fs-5 fw-bold">SMKN 2 KUDUS</span>
                            <small class="fst-italic">Ds. Rejosari Kecamatan Dawe kabupaten Kudus 59353</small>
                        </div>
                    </div>
                </div>
                <div class="me-2">
                    <div class="d-flex justify-content-start align-items-center gap-2">
                        <div class="border border-black icon-padding border-top-0 border-bottom-0">
                            <img src="<?php echo e(url('/img/skada-icon.png')); ?>" class="icon-dimension" alt="" />
                        </div>
                        <div class="d-flex justify-content-start align-items-center flex-column">
                            <div class="">No Dokumen</div>
                            <div class="">FF.BRMD.1212</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- MENJUDUL -->
            <div class="w-100 mb-5 d-flex justify-content-center align-items-center flex-column">
                <div class="fw-bold">JURNAL KEGIATAN BELAJAR MENGAJAR (KBM)</div>
                <div class="fw-bold">SMKN 2 KUDUS</div>
            </div>

            <!-- Biodata -->
            <div class="d-flex mb-2 justify-content-center align-items-center w-100">
                <div class="row row-cols-2">
                    <div class="col">
                        <div class="d-flex">
                            <div class="fw-bold" style="width: 150px">Nama Guru</div>
                            <div class="">: <?php echo e($data['nama_guru']); ?></div>
                        </div>
                    </div>
                    <div class="col">
                        <div class="d-flex">
                            <div class="fw-bold" style="width: 150px">Tahun Pelajaran</div>
                            <div class="">: <?php echo e($data['tahun_pelajaran']); ?></div>
                        </div>
                    </div>
                    <div class="col">
                        <div class="d-flex">
                            <div class="fw-bold" style="width: 150px">Mata Pelajaran</div>
                            <div class="">: <?php echo e($data['mapel']); ?></div>
                        </div>
                    </div>
                    <div class="col">
                        <div class="d-flex">
                            <div class="fw-bold" style="width: 150px">Semester</div>
                            <div class="">: <?php echo e($data['semester']); ?></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Tabel Kebilekan -->
            <div class="">
                <table class="table-sm table-bordered table border-black">
                    <thead class="text-center">
                        <tr>
                            <th rowspan="2" class="py-3">No</th>
                            <th rowspan="2" class="py-3">Tanggal</th>
                            <th rowspan="2" class="py-3" width="100px">Jam Ke</th>
                            <th rowspan="2" class="py-3">Kelas</th>
                            <th rowspan="2" class="py-3" width="300px">
                                Materi yang disampaikan
                            </th>
                            <th rowspan="2" colspan="1" align="center" center="center">
                                Hadir
                            </th>
                            <th rowspan="1" colspan="3">Tak Hadir</th>
                            <th rowspan="2" class="py-3">Ket</th>
                        </tr>
                        <tr>
                            <th>I</th>
                            <th>S</th>
                            <th>A</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(count($data['jurnals']) > 0): ?>
                            <?php $__currentLoopData = $data['jurnals']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="text-center">
                                    <td><?php echo e($index + 1); ?></td>
                                    <td><?php echo e(date_format(date_create($item->date), 'd F Y')); ?></td>
                                    <td><?php echo e($item->jam_ke_start); ?>

                                        <?php echo e($item->jam_ke_end ? '- ' . $item->jam_ke_end : ''); ?></td>
                                    <td><?php echo e($item->kelas->kelas); ?></td>
                                    <td>
                                        <div class="d-flex m-2 justify-content-start align-items-start flex-column">
                                            <div>Judul : <?php echo e($item->judul); ?></div>
                                            <div>Materi : </div>
                                            <ol>
                                                <?php $__currentLoopData = $item->jurnal; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $jurInd): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li><?php echo e($jurInd); ?></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ol>
                                        </div>
                                    </td>
                                    <td><?php echo e($item->kehadiran->hadir); ?></td>
                                    <td><?php echo e($item->kehadiran->sakit ?? '-'); ?></td>
                                    <td><?php echo e($item->kehadiran->izin ?? '-'); ?></td>
                                    <td><?php echo e($item->kehadiran->alasan ?? '-'); ?></td>
                                    <td><?php echo e($item->keterangan ?? '-'); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous">
    </script>
</body>

</html>
<?php /**PATH C:\Users\AhmadBasikal\Projects\aku_jurnal\resources\views/Jurnal/export.blade.php ENDPATH**/ ?>