<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title><?php echo e($data['title']); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous" />

    <style>
        * {
            font-family: "Calibri", sans-serif;
        }

        .icon-dimension {
            width: 90px;
            height: 90px;
        }

        .hr-style {
            border: 2px solid #1c1c1c;
            opacity: 1;
            margin: 0;
            border-radius: 10px;
        }

        .head-title {
            line-height: 18px;
        }

        th, td {
            vertical-align: middle;
        }
    </style>
</head>

<body class="bg-white">
    <div class="h-100 w-100">
        <div class="mx-5 mt-3">
            <!-- KOB SURAD -->
            <div class="d-flex gap-4 mb-1 justify-content-center w-100 align-items-center">
                <!-- BPTIK😁 -->
                <div class="">
                    <img src="<?php echo e(url('img/jateng.png')); ?>" class="icon-dimension" alt="" />
                </div>

                <!-- Head -->
                <div class="d-flex flex-column justify-content-center align-items-center">
                    <span class="fw-bold head-title">PEMERINTAH PROVINSI JAWA TENGAH</span>
                    <span class="fw-bold head-title">DINAS PENDIDIKAN DAN KEBUDAYAAN</span>
                    <span class="fw-bold head-title" style="font-size: 18px">SEKOLAH MENENGAH KEJURUAN NEGERI 2
                        KUDUS</span>
                    <span class="fw-regular mt-2" style="font-size: 10px; line-height: 12px">Jalan Desa Rejosari Dawe
                        Kudus Kode Pos 59353 Telepon
                        0291-4101149</span>
                    <span class="fw-regular" style="font-size: 10px; line-height: 12px">Website www.smkn2kudus.sch.id
                        Surat Elektronik
                        smkn2kudus@gmail.com</span>
                </div>
            </div>

            <center class="mb-4">
                <hr class="hr-style" />
            </center>

            <!-- MENJUDUL -->
            <div class="w-100 mb-3 d-flex justify-content-center align-items-center flex-column">
                <div class="fw-bold">JURNAL KEGIATAN BELAJAR MENGAJAR (KBM)</div>
                <div class="fw-bold">SMKN 2 KUDUS</div>
            </div>

            <!-- Biodata -->
            <div class="d-flex mb-2 justify-content-center align-items-center w-100">
                <div class="row row-cols-2">
                    <div class="col">
                        <div class="d-flex">
                            <div class="fw-bold" style="width: 150px">Nama Guru</div>
                            <div class="">: <?php echo e($data['nama_guru']); ?></div>
                        </div>
                    </div>
                    <div class="col">
                        <div class="d-flex">
                            <div class="fw-bold" style="width: 150px">Kelas</div>
                            <div class="">: <?php echo e($data['kelas']); ?></div>
                        </div>
                    </div>
                    <div class="col">
                        <div class="d-flex">
                            <div class="fw-bold" style="width: 150px">Mata Pelajaran</div>
                            <div class="">: <?php echo e($data['mapel']); ?></div>
                        </div>
                    </div>
                    <div class="col">
                        <div class="d-flex">
                            <div class="fw-bold" style="width: 150px">Rentang Tanggal</div>
                            <div class="">: <?php echo e($data['rentang_tanggal']); ?></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Tabel Kebilekan -->
            <div class="">
                <table class="table-sm table-bordered table border-black">
                    <thead class="text-center">
                        <tr>
                            <th rowspan="2" class="py-3">No</th>
                            <th rowspan="2" class="py-3">Tanggal</th>
                            <th rowspan="2" class="py-3" width="100px">Jam Ke</th>
                            <th rowspan="2" class="py-3">Kelas</th>
                            <th rowspan="2" class="py-3" width="300px">
                                Materi yang disampaikan
                            </th>
                            <th rowspan="2" colspan="1" align="center" center="center">
                                Hadir
                            </th>
                            <th rowspan="1" colspan="3">Tak Hadir</th>
                            <th rowspan="2" class="py-3">Ket</th>
                        </tr>
                        <tr>
                            <th>S</th>
                            <th>I</th>
                            <th>A</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(count($data['jurnals']) > 0): ?>
                            <?php $__currentLoopData = $data['jurnals']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="text-center">
                                    <td><?php echo e($index + 1); ?></td>
                                    <td><?php echo e(date_format(date_create($item->date), 'd F Y')); ?></td>
                                    <td><?php echo e($item->jam_ke_start); ?>

                                        <?php echo e($item->jam_ke_end ? '- ' . $item->jam_ke_end : ''); ?></td>
                                    <td><?php echo e($item->kelas->kelas); ?></td>
                                    <td>
                                        <div class="d-flex justify-content-start align-items-start flex-column">
                                            <div><?php echo e($item->judul); ?></div>
                                            <?php if(!empty($item->kehadiran->siswa_tak_hadir) && count($item->kehadiran->siswa_tak_hadir) > 0 ): ?>
                                                <span class="text-start border-top border-black w-100" style="font-size: 13px">Siswa yang tidak hadir :
                                                    <?php $__currentLoopData = $item->kehadiran->siswa_tak_hadir; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $siswa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php echo e($siswa->siswa->nama); ?>

                                                        <?php echo e($loop->last ? '' : ', '); ?>

                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td><?php echo e($item->kehadiran->hadir); ?></td>
                                    <td><?php echo e($item->kehadiran->sakit ?? '-'); ?></td>
                                    <td><?php echo e($item->kehadiran->izin ?? '-'); ?></td>
                                    <td><?php echo e($item->kehadiran->alasan ?? '-'); ?></td>
                                    <td><?php echo e($item->keterangan ?? '-'); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous">
    </script>

    <script>
        window.onload = () => window.print()
    </script>
</body>

</html>
<?php /**PATH /home/zona4001/public_html/aku_jurnal/resources/views/Jurnal/export.blade.php ENDPATH**/ ?>