<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\GuruController;
use App\Http\Controllers\JurnalController;
use App\Http\Controllers\MapelController;
use App\Http\Controllers\SiswaController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/login', [AuthController::class, 'index'])->name('login')->middleware('guest');
Route::post('/login', [AuthController::class, 'login'])->middleware('guest');

Route::middleware('auth')->group(function(){
    Route::post('/logout', [AuthController::class, 'logout']);
    Route::get('/', [DashboardController::class, 'index']);

    Route::middleware('AdminOnly')->group(function(){
        // Guru
        Route::resource('guru', GuruController::class)->except('update');
        Route::post('guru/import', [GuruController::class, 'import']);
        Route::post('guru/update', [GuruController::class, 'update']);

        // Mapel
        Route::resource('mapel', MapelController::class)->except('update');
        Route::post('mapel/import', [MapelController::class, 'import']);
        Route::post('mapel/update', [MapelController::class, 'update']);

        // Siswa (On Development)
        Route::resource('siswa', SiswaController::class)->except('update');
        Route::post('siswa/import', [SiswaController::class, 'import']);
        Route::post('siswa/update', [SiswaController::class, 'update']);
    });

    // Jurnals
    Route::resource('jurnal', JurnalController::class)->except('update', 'show', 'destroy');
    Route::middleware('GuruOnly')->group(function(){
        // Jurnals Crud
        Route::get('/jurnal/{id}', [JurnalController::class, 'show']);
        Route::delete('/jurnal/{id}', [JurnalController::class, 'destroy']);
        Route::post('jurnal/update', [JurnalController::class, 'update']);
        Route::post('jurnal/export', [JurnalController::class, 'export']);

        // Get Siswa by Kelas
        Route::get('siswa/kelas/{kelas_id}', [SiswaController::class, 'getSiswaByKelas']);
    });
});
