@extends('Layout.layout')
@section('layout')
    <link rel="stylesheet" href="/assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="/assets/compiled/css/table-datatable-jquery.css">
    <link rel="stylesheet" href="/assets/extensions/filepond/filepond.css">
    <link rel="stylesheet" href="/assets/extensions/choices.js/public/assets/styles/choices.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <link rel="stylesheet" type="text/css" href="https://npmcdn.com/flatpickr/dist/themes/airbnb.css">

    <style>
        .dashed-borders {
            border-style: dashed !important;
            border-top: none !important;
            border-left: none !important;
            border-right: none !important;
        }

        .choices__inner {
            background: #fff;
        }
    </style>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    @can('adminOnly')
                        <h4>Data Jurnal Guru</h4>
                    @else
                        <h4>Data Jurnal Saya</h4>
                        <div class="d-flex justify-content-between align-items-center gap-3">
                            <button class="btn btn-primary d-flex justify-content-center align-items-center"
                                data-bs-toggle="modal" data-bs-target="#aksiLainnyaModal">
                                <i class="bi bi-three-dots-vertical mb-2 me-md-1"></i>
                                <small class="d-none d-md-block">Aksi Lainnya</small>
                            </button>
                        </div>
                    @endcan
                </div>
                <div class="card-body">
                    <div class="table-responsive datatable-minimal">
                        <table class="table" id="table2">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    @can('adminOnly')
                                        <th>Guru</th>
                                    @endcan
                                    <th>Kelas</th>
                                    <th>Mapel</th>
                                    <th>Tanggal</th>
                                    <th>Jam Pembelajaran</th>
                                    <th>Jurnal</th>
                                    <th>Kegiatan</th>
                                    @can('guruOnly')
                                        <th>Action</th>
                                    @endcan
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($jurnals as $i => $item)
                                    <tr>
                                        <td>{{ $i + 1 }}</td>
                                        @can('adminOnly')
                                            <td>{{ $item->user->nama_lengkap }}</td>
                                        @endcan
                                        <td>{{ $item->kelas->kelas }}</td>
                                        <td>{{ $item->mapel->mapel }}</td>
                                        <td>{{ date_format(date_create($item->date), 'd F Y') }}</td>
                                        <td>{{ $item->jam_ke_start }} {{ $item->jam_ke_end ? '- ' . $item->jam_ke_end : '' }}
                                        </td>
                                        <td>{{ $item->judul }}</td>
                                        <td>
                                            <ol>
                                                @foreach ($item->jurnal as $jurInd)
                                                    <li>{{ $jurInd }}</li>
                                                @endforeach
                                            </ol>
                                        </td>
                                        @can('guruOnly')
                                            <td>
                                                <div class="d-flex justify-content-start align-items-center gap-2">
                                                    <button class="btn btn-light-primary" data-bs-toggle="modal"
                                                        data-bs-target="#editJurnalModal" onclick="edit({{ $item->id }})">
                                                        <i class="bi bi-pencil-fill mb-2"></i>
                                                    </button>
                                                    <form method="POST" action="{{ url('jurnal/' . $item->id) }}"
                                                        data-bs-toggle="modal" id="delete_siswa_form_{{ $item->id }}"
                                                        onsubmit="confirmSubmit(event, {{ $item->id }})"
                                                        data-bs-target="#border-less">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-light-danger">
                                                            <i class="bi bi-trash-fill mb-2"></i>
                                                        </button>
                                                    </form>
                                                </div>
                                            </td>
                                        @endcan
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

    @include('Components.Jurnal.create_modal')
    @include('Components.Jurnal.edit_modal')
    @include('Components.Jurnal.delete_modal')
    @include('Components.Jurnal.other_modal')

    <script src="/assets/extensions/jquery/jquery.min.js"></script>
    <script src="/assets/extensions/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="/assets/extensions/datatables.net-bs5/js/dataTables.bootstrap5.min.js"></script>
    <script src="/assets/static/js/pages/datatables.js"></script>
    <script src="/assets/extensions/filepond/filepond.js"></script>
    <script src="/assets/static/js/pages/filepond.js"></script>
    <script src="/assets/extensions/choices.js/public/assets/scripts/choices.js"></script>
    <script src="/assets/static/js/pages/form-element-select.js"></script>

    @include('Components.Jurnal.export_selection')

    {{-- Custom --}}
    <script>
        function siswaTakHadir(element_id, isEdit) {
            if (!isEdit) {
                if ($('#sakit').val() || $('#izin').val() || $('#alasan').val()) {
                    if ($('#sakit').val() != 0 || $('#izin').val() != 0 || $('#alasan').val() != 0) {
                        $(`#${element_id}`).show();
                    } else {
                        $(`#${element_id}`).hide();
                    }
                } else {
                    $(`#${element_id}`).hide();
                }
            } else {
                if ($('#edit_sakit').val() || $('#edit_izin').val() || $('#edit_alasan').val()) {
                    if ($('#edit_sakit').val() != 0 || $('#edit_izin').val() != 0 || $('#edit_alasan').val() != 0) {
                        $(`#${element_id}`).show();
                    } else {
                        $(`#${element_id}`).hide();
                    }
                } else {
                    $(`#${element_id}`).hide();
                }
            }
            return;
        }

        let choicesJurnalCreate;
        let choicesJurnalEdit;

        function loadChoices() {
            choicesJurnalCreate = new Choices('#siswa_tak_hadir', {
                allowHTML: true,
                placeholder: true,
                removeItems: true,
                removeItemButton: true,
                placeholderValue: 'Cari dan pilih siswa',
                searchPlaceholderValue: 'Pilih siswa',
            });
            choicesJurnalEdit = new Choices('#edit_siswa_tak_hadir', {
                allowHTML: true,
                placeholder: true,
                removeItems: true,
                removeItemButton: true,
                placeholderValue: 'Cari dan pilih siswa',
                searchPlaceholderValue: 'Pilih siswa',
            });
        }

        async function getSiswaList(kelas_id, target, prev_siswa = null) {
            switch (target) {
                case "create":
                    await choicesJurnalCreate.clearStore();
                case "edit":
                    await choicesJurnalEdit.clearStore();
            }
            await $.ajax({
                type: 'get',
                url: `{{ url('siswa/kelas/${kelas_id}') }}`,
                success: function(data) {
                    switch (target) {
                        case "create":
                            choicesJurnalCreate.setChoices(data, 'value', 'label', true);
                            break;
                        case "edit":
                            prev_siswa.map((item) => {
                                let index = data.findIndex((data) => data.value == item.value)
                                data.splice(index,1)
                            })
                            choicesJurnalEdit.setChoices(data, 'value', 'label', true);
                            break;
                    }
                }
            })
        }

        async function getChoicesValue(target) {
            let selectedChoices;
            switch (target) {
                case "create":
                    selectedChoices = choicesJurnalCreate.getValue();
                    break;
                case "edit":
                    selectedChoices = choicesJurnalEdit.getValue();
                    break;
            }
            return selectedChoices.map((item) => ({
                label: item.label,
                value: item.value,
            }));
        }

        loadChoices();
    </script>
@endsection
