<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>{{ $data['title'] }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous" />

    <style>
        * {
            font-family: "Calibri", sans-serif;
        }

        .icon-dimension {
            width: 90px;
            height: 90px;
        }

        .hr-style {
            border: 2px solid #1c1c1c;
            opacity: 1;
            margin: 0;
            border-radius: 10px;
        }

        .head-title {
            line-height: 18px;
        }

        th, td {
            vertical-align: middle;
        }
    </style>
</head>

<body class="bg-white">
    <div class="h-100 w-100">
        <div class="mx-5 mt-3">
            <!-- KOB SURAD -->
            <div class="d-flex gap-4 mb-1 justify-content-center w-100 align-items-center">
                <!-- BPTIK😁 -->
                <div class="">
                    <img src="{{ url('img/jateng.png') }}" class="icon-dimension" alt="" />
                </div>

                <!-- Head -->
                <div class="d-flex flex-column justify-content-center align-items-center">
                    <span class="fw-bold head-title">PEMERINTAH PROVINSI JAWA TENGAH</span>
                    <span class="fw-bold head-title">DINAS PENDIDIKAN DAN KEBUDAYAAN</span>
                    <span class="fw-bold head-title" style="font-size: 18px">SEKOLAH MENENGAH KEJURUAN NEGERI 2
                        KUDUS</span>
                    <span class="fw-regular mt-2" style="font-size: 10px; line-height: 12px">Jalan Desa Rejosari Dawe
                        Kudus Kode Pos 59353 Telepon
                        0291-4101149</span>
                    <span class="fw-regular" style="font-size: 10px; line-height: 12px">Website www.smkn2kudus.sch.id
                        Surat Elektronik
                        smkn2kudus@gmail.com</span>
                </div>
            </div>

            <center class="mb-4">
                <hr class="hr-style" />
            </center>

            <!-- MENJUDUL -->
            <div class="w-100 mb-3 d-flex justify-content-center align-items-center flex-column">
                <div class="fw-bold">JURNAL KEGIATAN BELAJAR MENGAJAR (KBM)</div>
                <div class="fw-bold">SMKN 2 KUDUS</div>
            </div>

            <!-- Biodata -->
            <div class="d-flex mb-2 justify-content-center align-items-center w-100">
                <div class="row row-cols-2">
                    <div class="col">
                        <div class="d-flex">
                            <div class="fw-bold" style="width: 150px">Nama Guru</div>
                            <div class="">: {{ $data['nama_guru'] }}</div>
                        </div>
                    </div>
                    <div class="col">
                        <div class="d-flex">
                            <div class="fw-bold" style="width: 150px">Kelas</div>
                            <div class="">: {{ $data['kelas'] }}</div>
                        </div>
                    </div>
                    <div class="col">
                        <div class="d-flex">
                            <div class="fw-bold" style="width: 150px">Mata Pelajaran</div>
                            <div class="">: {{ $data['mapel'] }}</div>
                        </div>
                    </div>
                    <div class="col">
                        <div class="d-flex">
                            <div class="fw-bold" style="width: 150px">Rentang Tanggal</div>
                            <div class="">: {{ $data['rentang_tanggal'] }}</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Tabel Kebilekan -->
            <div class="">
                <table class="table-sm table-bordered table border-black">
                    <thead class="text-center">
                        <tr>
                            <th rowspan="2" class="py-3">No</th>
                            <th rowspan="2" class="py-3">Tanggal</th>
                            <th rowspan="2" class="py-3" width="100px">Jam Ke</th>
                            <th rowspan="2" class="py-3">Kelas</th>
                            <th rowspan="2" class="py-3" width="300px">
                                Materi yang disampaikan
                            </th>
                            <th rowspan="2" colspan="1" align="center" center="center">
                                Hadir
                            </th>
                            <th rowspan="1" colspan="3">Tak Hadir</th>
                            <th rowspan="2" class="py-3">Ket</th>
                        </tr>
                        <tr>
                            <th>S</th>
                            <th>I</th>
                            <th>A</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if (count($data['jurnals']) > 0)
                            @foreach ($data['jurnals'] as $index => $item)
                                <tr class="text-center">
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ date_format(date_create($item->date), 'd F Y') }}</td>
                                    <td>{{ $item->jam_ke_start }}
                                        {{ $item->jam_ke_end ? '- ' . $item->jam_ke_end : '' }}</td>
                                    <td>{{ $item->kelas->kelas }}</td>
                                    <td>
                                        <div class="d-flex justify-content-start align-items-start flex-column">
                                            <div>{{ $item->judul }}</div>
                                            @if (!empty($item->kehadiran->siswa_tak_hadir) && count($item->kehadiran->siswa_tak_hadir) > 0 )
                                                <span class="text-start border-top border-black w-100" style="font-size: 13px">Siswa yang tidak hadir :
                                                    @foreach ($item->kehadiran->siswa_tak_hadir as $siswa)
                                                        {{ $siswa->siswa->nama }}
                                                        {{ $loop->last ? '' : ', ' }}
                                                    @endforeach
                                                </span>
                                            @endif
                                        </div>
                                    </td>
                                    <td>{{ $item->kehadiran->hadir }}</td>
                                    <td>{{ $item->kehadiran->sakit ?? '-' }}</td>
                                    <td>{{ $item->kehadiran->izin ?? '-' }}</td>
                                    <td>{{ $item->kehadiran->alasan ?? '-' }}</td>
                                    <td>{{ $item->keterangan ?? '-' }}</td>
                                </tr>
                            @endforeach
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous">
    </script>

    <script>
        window.onload = () => window.print()
    </script>
</body>

</html>
