@extends('Layout.layout')
@section('layout')

    <link rel="stylesheet" href="/assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="/assets/compiled/css/table-datatable-jquery.css">



    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>Data Guru Aku Jurnal</h4>
                    <div class="d-flex justify-content-between align-items-center gap-3">
                        <button class="btn btn-primary d-flex justify-content-center align-items-center" data-bs-toggle="modal" data-bs-target="#aksiLainnyaModal">
                            <i class="bi bi-three-dots-vertical mb-2 me-md-1"></i>
                            <small class="d-none d-md-block">Aksi Lainnya</small>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive datatable-minimal">
                        <table class="table" id="table2">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>NIP</th>
                                    <th>Nama</th>
                                    <th>Guru Mapel</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($gurus as $i => $item)
                                    <tr>
                                        <td>{{ $i + 1 }}</td>
                                        <td>{{ $item->nip }}</td>
                                        <td>{{ $item->nama_lengkap }}</td>
                                        <td>{{ $item->mapel->mapel }}</td>
                                        <td>
                                            <div class="d-flex justify-content-start align-items-center gap-2">
                                                <button class="btn btn-light-primary" data-bs-toggle="modal"
                                                    data-bs-target="#editBarangModal" onclick="edit({{ $item->id }})">
                                                    <i class="bi bi-pencil-fill mb-2"></i>
                                                </button>
                                            <form method="POST" action="{{ url('guru/' . $item->id) }}"
                                                    data-bs-toggle="modal" id="delete_siswa_form_{{ $item->id }}"
                                                    onsubmit="confirmSubmit(event, {{ $item->id }})"
                                                    data-bs-target="#border-less">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-light-danger">
                                                        <i class="bi bi-trash-fill mb-2"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="/assets/extensions/jquery/jquery.min.js"></script>
    <script src="/assets/extensions/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="/assets/extensions/datatables.net-bs5/js/dataTables.bootstrap5.min.js"></script>
    <script src="/assets/static/js/pages/datatables.js"></script>


    @include('Components.Guru.create_modal')
    @include('Components.Guru.edit_modal')
    @include('Components.Guru.delete_modal')
    @include('Components.Guru.import_modal')
    @include('Components.Guru.other_modal')

    {{-- Custom --}}
    <script>
        async function NIPRegex(element_id) {
            var value = $(element_id).val().replace(/\D/g, '');
            if (value.length > 18) value = value.slice(0, 18);
            var formattedValue = value;
            if (value.length > 8) {
                formattedValue = value.slice(0, 8) + ' ' + value.slice(8);
            }
            if (value.length > 13) {
                formattedValue = formattedValue.slice(0, 15) + ' ' + formattedValue.slice(15);
            }
            if (value.length > 16) {
                formattedValue = formattedValue.slice(0, 17) + ' ' + formattedValue.slice(17);
            }
            $(element_id).val(formattedValue);
        }
    </script>

@endsection
