    {{-- Edit Data Modals --}}
    <div class="modal fade text-left" id="editBarangModal" tabindex="-1" role="dialog"
        aria-labelledby="myModalLabel33" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myModalLabel33">Edit Data Siswa</h4>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i data-feather="x"></i>
                    </button>
                </div>
                <form action="{{ url('/siswa/update') }}" method="POST">
                    @csrf
                    <input type="hidden" id="edit_id" name="edit_id" value="">
                    <div class="modal-body" id="edit_container">
                        <label for="edit_nis">NIS</label>
                        <div class="form-group">
                            <input required id="edit_nis" oninput="NISRegex('#edit_nis')" name="edit_nis" type="text" class="form-control">
                        </div>
                        <label for="edit_nama">Nama Lengkap</label>
                        <div class="form-group">
                            <input required id="edit_nama" name="edit_nama" type="text" class="form-control">
                        </div>
                        <label for="edit_gender">Gender</label>
                        <div class="form-group">
                            <select required name="edit_gender" id="edit_gender"
                                class="form-select">
                                <option value="" selected>Pilih Gender</option>
                                <option value="L">L</option>
                                <option value="P">P</option>
                            </select>
                        </div>
                        <label for="edit_kelas_id">Kelas</label>
                        <div class="form-group">
                            <select required name="edit_kelas_id" id="edit_kelas_id"
                                class="form-select">
                                <option value="" selected>Pilih Kelas</option>
                                @if ($kelas_list)
                                    @foreach ($kelas_list as $item)
                                        <option value="{{ $item->id }}">{{ $item->kelas }}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-light-secondary" data-bs-dismiss="modal">
                            <i class="bx bx-x d-block d-sm-none"></i>
                            <span class="d-none d-sm-block">Close</span>
                        </button>
                        <button type="submit" class="btn btn-primary ms-1">
                            <i class="bx bx-check d-block d-sm-none"></i>
                            <span class="d-none d-sm-block">Update</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        async function edit(id) {
            $("#edit_container").css({
                opacity: 0,
                transition: "all ease 0.3s"
            });
            await $.ajax({
                type: 'get',
                url: `{{ url('siswa/${id}') }}`,
                success: function(data) {
                    $("#edit_id").val(data.id);
                    $("#edit_nis").val(data.nis);
                    $("#edit_nama").val(data.nama);
                    $("#edit_gender").val(data.gender);
                    $("#edit_kelas_id").val(data.kelas_id);

                    $("#edit_container").css({
                        opacity: 1,
                        transition: "all ease 0.3s"
                    });
                }
            })
        }
    </script>
