{{-- Export Jurnal --}}
<div class="modal fade text-left" id="selectSemesterModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel19"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="myModalLabel19">Export dan Cetak Jurnal</h4>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i data-feather="x"></i>
                </button>
            </div>
            <form action="{{ url('jurnal/export') }}" target="_blank" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="container">
                        <div class="d-flex justify-content-start align-items-center gap-3">
                            <div class="" style="width: 33.33%">
                                <div class="">Mapel</div>
                                <select required name="mapel_export" id="mapel_export" class="form-control">
                                    <option value="">Pilih Mapel</option>
                                    @foreach ($mapel_list as $mapel)
                                        <option value="{{ $mapel->id }}">{{ $mapel->mapel }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="w-50" style="width: 33.33%">
                                <div class="">Kelas</div>
                                <select required name="kelas_export" id="kelas_export" class="form-control">
                                    <option value="">Pilih Kelas</option>
                                    @foreach ($kelas_list as $kelas)
                                        <option value="{{ $kelas->id }}">{{ $kelas->kelas }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="w-50" style="width: 33.33%">
                                <input type="hidden" name="start_date" id="start_date">
                                <input type="hidden" name="end_date" id="end_date">
                                <div class="">Rentang Tanggal</div>
                                <input type="text" class="form-control" id="date_range">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light-secondary btn-sm" data-bs-dismiss="modal">
                        <span class="">Close</span>
                    </button>
                    <button type="submit" class="btn btn-primary ms-1 btn-sm">
                        <span class="">Export</span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    const separateDate = (dateString) => {
        let dates = dateString.split(" -- ");
        $("#start_date").val(dates[0])
        $("#end_date").val(dates[1])
    };
    flatpickr('#date_range', {
        altInput: true,
        dateFormat: "Y-m-d",
        altFormat: "d F Y",
        mode : "range",
        onChange: (date, string_date) => {
            separateDate(string_date);
        },
        locale: {
            rangeSeparator: " -- ",
        },
    })
</script>
