    {{-- Edit Data Modals --}}
    <div class="modal fade text-left" id="editJurnalModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel33"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-full" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myModalLabel33">Edit Jurnal</h4>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i data-feather="x"></i>
                    </button>
                </div>
                <form action="{{ url('/jurnal/update') }}" id="edit_container" onsubmit="editSubmit(event)"
                    method="POST">
                    @csrf
                    <input type="hidden" name="edit_id" id="edit_id">
                    <input type="hidden" name="kehadiran_id" id="kehadiran_id">
                    <div class="modal-body">
                        <div class="d-flex justify-content-start align-items-start" style="gap: 3em">
                            <div class="w-50">
                                {{-- Mapel Kelas Jam Pembelajaran --}}
                                <div class="mb-4">
                                    <h3 class="fs-5 mb-2 d-flex justify-content-start align-items-center gap-3">
                                        <i class="bi bi-1-circle-fill" style="margin-bottom: 0.6em;"></i>
                                        <span>Mapel, Kelas, & Jam Pembelajaran</span>
                                    </h3>
                                    <div class="d-flex flex-wrap justify-content-start align-items-start">
                                        <div class="w-50 pe-2">
                                            <label for="edit_mapel_id">Mapel</label>
                                            <div class="form-group">
                                                <select required name="edit_mapel_id" id="edit_mapel_id"
                                                    class="form-control">
                                                    <option value="" selected>Pilih Mapel</option>
                                                    @if ($mapel_list)
                                                        @foreach ($mapel_list as $item)
                                                            <option value="{{ $item->id }}"
                                                                @selected($item->id == auth()->user()->mapel_id)>
                                                                {{ $item->mapel }}</option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <div class="w-50 ps-2">
                                            <label for="edit_kelas_id">Kelas</label>
                                            <div class="form-group">
                                                <select required name="edit_kelas_id"
                                                    onchange="getSiswaList(event.target.value, 'edit')"
                                                    id="edit_kelas_id" class="form-control">
                                                    <option value="" selected>Pilih Kelas</option>
                                                    @if ($kelas_list)
                                                        @foreach ($kelas_list as $item)
                                                            <option value="{{ $item->id }}">{{ $item->kelas }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <div class="w-100">
                                            <label for="jam_ke">Jam Pembelajaran Ke</label>
                                            <div class="form-group">
                                                <div class="d-flex justify-content-start align-items-center gap-2">
                                                    <select required name="edit_jam_ke_start" id="edit_jam_ke_start"
                                                        class="form-control text-center">
                                                        <option value="" selected>Mulai</option>
                                                        @for ($i = 1; $i <= 11; $i++)
                                                            <option value="{{ $i }}">{{ $i }}
                                                            </option>
                                                        @endfor
                                                    </select>
                                                    <div class="">-</div>
                                                    <select name="edit_jam_ke_end" required id="edit_jam_ke_end"
                                                        class="form-control text-center">
                                                        <option value="" selected>Sampai</option>
                                                        @for ($i = 1; $i <= 11; $i++)
                                                            <option value="{{ $i }}">{{ $i }}
                                                            </option>
                                                        @endfor
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                {{-- Jurnal & Kegiatannya --}}
                                <div class="">
                                    <h3 class="fs-5 mb-2 d-flex justify-content-start align-items-center gap-3">
                                        <i class="bi bi-2-circle-fill" style="margin-bottom: 0.6em;"></i>
                                        <span>Jurnal & Kegiatannya</span>
                                    </h3>
                                    <div class="">
                                        <label for="edit_judul">Jurnal</label>
                                        <div class="form-group">
                                            <input type="text" required name="edit_judul" id="edit_judul"
                                                class="form-control">
                                        </div>
                                    </div>
                                    <div class="">
                                        <label for="edit_jurnal">Kegiatan</label>
                                        <div class="form-group">
                                            <textarea name="edit_jurnal" required id="edit_jurnal" placeholder="Pisahkan dengan Enter" cols="30" rows="5"
                                                class="form-control"></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="w-50">
                                {{-- Absensi Siswa --}}
                                <div class="">
                                    <h3 class="fs-5 mb-2 d-flex justify-content-start align-items-center gap-3">
                                        <i class="bi bi-3-circle-fill" style="margin-bottom: 0.6em;"></i>
                                        <span>Absensi Siswa</span>
                                    </h3>
                                    <div class="">
                                        <label for="edit_date">Tanggal</label>
                                        <div class="form-group">
                                            <input type="text" required name="edit_date" id="edit_date"
                                                class="form-control">
                                        </div>
                                    </div>
                                    <div class="d-flex justify-content-start align-items-start gap-3 mb-3">
                                        <div class="w-25">
                                            <label for="edit_hadir">Hadir</label>
                                            <div class="form-group">
                                                <input type="number" min="0" max="40" required
                                                    name="edit_hadir" id="edit_hadir" class="form-control">
                                            </div>
                                        </div>
                                        <div class="w-25">
                                            <label for="edit_sakit">Sakit</label>
                                            <div class="form-group">
                                                <input oninput="siswaTakHadir('edit_siswa_tak_hadir_container', true)"
                                                    type="number" min="0" max="40" name="edit_sakit"
                                                    id="edit_sakit" class="form-control">
                                            </div>
                                        </div>
                                        <div class="w-25">
                                            <label for="edit_izin">Izin</label>
                                            <div class="form-group">
                                                <input oninput="siswaTakHadir('edit_siswa_tak_hadir_container', true)"
                                                    type="number" min="0" max="40" name="edit_izin"
                                                    id="edit_izin" class="form-control">
                                            </div>
                                        </div>
                                        <div class="w-25">
                                            <label for="edit_alasan">Alasan</label>
                                            <div class="form-group">
                                                <input oninput="siswaTakHadir('edit_siswa_tak_hadir_container', true)"
                                                    type="number" min="0" max="40" name="edit_alasan"
                                                    id="edit_alasan" class="form-control">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="" style="display: none" id="edit_siswa_tak_hadir_container">
                                        <label for="edit_siswa_tak_hadir">Siapa Saja Siswa yang Tidak Hadir ?</label>
                                        <div class="form-group">
                                            <select class="form-select multiple-remove" id="edit_siswa_tak_hadir"
                                                multiple="multiple">
                                                {{--  --}}
                                            </select>
                                        </div>
                                    </div>

                                    <input type="hidden" name="edit_siswa_tak_hadir_value"
                                        id="edit_siswa_tak_hadir_value">
                                </div>

                                <div class="">
                                    <h3 class="fs-5 mb-2 d-flex justify-content-start align-items-center gap-3">
                                        <i class="bi bi-4-circle-fill" style="margin-bottom: 0.6em;"></i>
                                        <span>Keterangan Tambahan</span>
                                    </h3>
                                    <div class="">
                                        <label for="edit_keterangan">Keterangan</label>
                                        <div class="form-group">
                                            <textarea name="edit_keterangan" id="edit_keterangan" cols="30" rows="3" class="form-control"></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light-secondary" data-bs-dismiss="modal">
                            <i class="bx bx-x d-block d-sm-none"></i>
                            <span class="d-none d-sm-block">Close</span>
                        </button>
                        <button type="submit" class="btn btn-primary ms-1">
                            <i class="bx bx-check d-block d-sm-none"></i>
                            <span class="d-none d-sm-block">Update</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        async function editSubmit(event) {
            await $("#edit_siswa_tak_hadir_value").val(JSON.stringify(await getChoicesValue('edit')))
        }
        async function edit(id) {
            $("#edit_container").css({
                opacity: 0,
                transition: "all ease 0.3s"
            });
            await $.ajax({
                type: 'get',
                url: `{{ url('jurnal/${id}') }}`,
                success: async function(data) {
                    const siswa_list = await data?.kehadiran?.siswa_tak_hadir?.map((item) => {
                        return {
                            value: item?.siswa_id?.toString(),
                            label: item?.siswa?.nama,
                        };
                    })
                    $("#edit_id").val(data?.id);
                    $("#kehadiran_id").val(data?.kehadiran_id);
                    await getSiswaList(data?.kelas_id, 'edit', siswa_list);
                    await $("#edit_kelas_id").val(data?.kelas_id);
                    $("#edit_mapel_id").val(data?.mapel_id);
                    $("#edit_jam_ke_start").val(data?.jam_ke_start);
                    $("#edit_jam_ke_end").val(data?.jam_ke_end);
                    $("#edit_judul").val(data?.judul);
                    $("#edit_jurnal").val(data?.jurnal);

                    flatpickr('#edit_date', {
                        altInput: true,
                        dateFormat: "Y-m-d",
                        altFormat: "d F Y",
                        defaultDate: data?.date,
                    })

                    $("#edit_hadir").val(data?.kehadiran?.hadir);
                    $("#edit_sakit").val(data?.kehadiran?.sakit);
                    $("#edit_izin").val(data?.kehadiran?.izin);
                    $("#edit_alasan").val(data?.kehadiran?.alasan);
                    $("#edit_keterangan").val(data?.keterangan);

                    if (data?.kehadiran?.siswa_tak_hadir?.length > 0) {
                        await siswaTakHadir('edit_siswa_tak_hadir_container', true);
                        await choicesJurnalEdit.setValue(siswa_list)
                    }

                    $("#edit_container").css({
                        opacity: 1,
                        transition: "all ease 0.3s"
                    });
                }
            })
        }
    </script>
