<!--Create Data Modal -->
<div class="modal fade text-left" id="createBarangModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel33"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-full" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="myModalLabel33">Jurnal Baru</h4>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i data-feather="x"></i>
                </button>
            </div>
            <form action="{{ url('/jurnal') }}" onsubmit="createSubmit(event)" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="d-flex justify-content-start align-items-start" style="gap: 3em">
                        <div class="w-50">
                            {{-- Mapel Kelas Jam Pembelajaran --}}
                            <div class="mb-4">
                                <h3 class="fs-5 mb-2 d-flex justify-content-start align-items-center gap-3">
                                    <i class="bi bi-1-circle-fill" style="margin-bottom: 0.6em;"></i>
                                    <span>Mapel, Kelas, & Jam Pembelajaran</span>
                                </h3>
                                <div class="d-flex flex-wrap justify-content-start align-items-start">
                                    <div class="w-50 pe-2">
                                        <label for="mapel_id">Mapel</label>
                                        <div class="form-group">
                                            <select required name="mapel_id" id="mapel_id" class="form-control">
                                                <option value="" selected>Pilih Mapel</option>
                                                @if ($mapel_list)
                                                    @foreach ($mapel_list as $item)
                                                        <option value="{{ $item->id }}"
                                                            @selected($item->id == auth()->user()->mapel_id)>
                                                            {{ $item->mapel }}</option>
                                                    @endforeach
                                                @endif
                                            </select>
                                        </div>
                                    </div>
                                    <div class="w-50 ps-2">
                                        <label for="kelas_id">Kelas</label>
                                        <div class="form-group">
                                            <select required name="kelas_id" onchange="getSiswaList(event.target.value, 'create')"
                                                id="kelas_id" class="form-control">
                                                <option value="" selected>Pilih Kelas</option>
                                                @if ($kelas_list)
                                                    @foreach ($kelas_list as $item)
                                                        <option value="{{ $item->id }}">{{ $item->kelas }}
                                                        </option>
                                                    @endforeach
                                                @endif
                                            </select>
                                        </div>
                                    </div>
                                    <div class="w-100">
                                        <label for="jam_ke">Jam Pembelajaran Ke</label>
                                        <div class="form-group">
                                            <div class="d-flex justify-content-start align-items-center gap-2">
                                                <select required name="jam_ke_start" id="jam_ke_start"
                                                    class="form-control text-center">
                                                    <option value="" selected>Mulai</option>
                                                    @for ($i = 1; $i <= 11; $i++)
                                                        <option value="{{ $i }}">{{ $i }}
                                                        </option>
                                                    @endfor
                                                </select>
                                                <div class="">-</div>
                                                <select name="jam_ke_end" required id="jam_ke_end"
                                                    class="form-control text-center">
                                                    <option value="" selected>Sampai</option>
                                                    @for ($i = 1; $i <= 11; $i++)
                                                        <option value="{{ $i }}">{{ $i }}
                                                        </option>
                                                    @endfor
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            {{-- Jurnal & Kegiatannya --}}
                            <div class="">
                                <h3 class="fs-5 mb-2 d-flex justify-content-start align-items-center gap-3">
                                    <i class="bi bi-2-circle-fill" style="margin-bottom: 0.6em;"></i>
                                    <span>Jurnal & Kegiatannya</span>
                                </h3>
                                <div class="">
                                    <label for="judul">Jurnal</label>
                                    <div class="form-group">
                                        <input type="text" required name="judul" id="judul"
                                            class="form-control">
                                    </div>
                                </div>
                                <div class="">
                                    <label for="jurnal">Kegiatan</label>
                                    <div class="form-group">
                                        <textarea name="jurnal" required id="jurnal" placeholder="Pisahkan dengan Enter" cols="30" rows="5"
                                            class="form-control"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="w-50">
                            {{-- Absensi Siswa --}}
                            <div class="mb-4">
                                <h3 class="fs-5 mb-2 d-flex justify-content-start align-items-center gap-3">
                                    <i class="bi bi-3-circle-fill" style="margin-bottom: 0.6em;"></i>
                                    <span>Absensi Siswa</span>
                                </h3>
                                <div class="">
                                    <label for="date">Tanggal</label>
                                    <div class="form-group">
                                        <input type="text" required name="date" id="date"
                                            class="form-control">
                                    </div>
                                </div>
                                <div class="d-flex justify-content-start align-items-start gap-3 mb-3">
                                    <div class="w-25">
                                        <label for="hadir">Hadir</label>
                                        <div class="form-group">
                                            <input type="number" min="0" max="40" required name="hadir"
                                                id="hadir" class="form-control">
                                        </div>
                                    </div>
                                    <div class="w-25">
                                        <label for="sakit">Sakit</label>
                                        <div class="form-group">
                                            <input oninput="siswaTakHadir('siswa_tak_hadir_container', false)"
                                                type="number" min="0" max="40" name="sakit"
                                                id="sakit" class="form-control">
                                        </div>
                                    </div>
                                    <div class="w-25">
                                        <label for="izin">Izin</label>
                                        <div class="form-group">
                                            <input oninput="siswaTakHadir('siswa_tak_hadir_container', false)"
                                                type="number" min="0" max="40" name="izin"
                                                id="izin" class="form-control">
                                        </div>
                                    </div>
                                    <div class="w-25">
                                        <label for="alasan">Alasan</label>
                                        <div class="form-group">
                                            <input oninput="siswaTakHadir('siswa_tak_hadir_container', false)"
                                                type="number" min="0" max="40" name="alasan"
                                                id="alasan" class="form-control">
                                        </div>
                                    </div>
                                </div>

                                <div class="" style="display: none" id="siswa_tak_hadir_container">
                                    <label for="siswa_tak_hadir">Siapa Saja Siswa yang Tidak Hadir ?</label>
                                    <div class="form-group">
                                        <select class="form-select multiple-remove" id="siswa_tak_hadir"
                                            multiple="multiple">
                                            {{--  --}}
                                        </select>
                                    </div>
                                </div>
                                <input type="hidden" name="siswa_tak_hadir_value" id="siswa_tak_hadir_value">
                            </div>

                            <div class="">
                                <h3 class="fs-5 mb-2 d-flex justify-content-start align-items-center gap-3">
                                    <i class="bi bi-4-circle-fill" style="margin-bottom: 0.6em;"></i>
                                    <span>Keterangan Tambahan</span>
                                </h3>
                                <div class="">
                                    <label for="keterangan">Keterangan</label>
                                    <div class="form-group">
                                        <textarea name="keterangan" id="keterangan" cols="30" rows="3"
                                            class="form-control"></textarea>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light-secondary" data-bs-dismiss="modal">
                        <i class="bx bx-x d-block d-sm-none"></i>
                        <span class="d-none d-sm-block">Close</span>
                    </button>
                    <button type="submit" class="btn btn-primary ms-1">
                        <i class="bx bx-check d-block d-sm-none"></i>
                        <span class="d-none d-sm-block">Tambah</span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    flatpickr('#date', {
        altInput: true,
        dateFormat: "Y-m-d",
        altFormat: "d F Y",
    })
    async function createSubmit(event) {
        await $("#siswa_tak_hadir_value").val(JSON.stringify(await getChoicesValue('create')))
    }
</script>
