<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('jurnals', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained();
            $table->foreignId('kelas_id')->constrained();
            $table->foreignId('mapel_id')->constrained();
            $table->foreignId('kehadiran_id')->constrained();
            $table->date('date')->default(now()->format('Y-m-d'));
            $table->string('jam_ke_start', 3);
            $table->string('jam_ke_end', 3)->nullable();
            $table->string('judul');
            $table->text('jurnal');
            $table->text('keterangan')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('jurnals');
    }
};
