<?php

namespace App\Imports;

use App\Models\Kelas;
use App\Models\Siswa;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class SiswaImport implements ToModel, WithHeadingRow
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        $kelas = Kelas::where('kelas', $row['kelas'])->first();
        if(!empty($kelas)){
            return new Siswa([
                'nis' => $row['nis'],
                'nama' => $row['nama'],
                'gender' => $row['gender'],
                'kelas_id' => $kelas['id'],
            ]);
        }
    }
}
