<?php

namespace App\Http\Controllers;

use App\Imports\SiswaImport;
use App\Models\SiswaTakHadir;
use App\Models\Kelas;
use App\Models\Siswa;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class SiswaController extends Controller
{
    private function getKelas(){
        $mapel = Kelas::all();
        return $mapel;
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $kelas_list = $this->getKelas();
        $title = "Data Siswa";
        $siswas = Siswa::with('kelas')->orderBy('kelas_id', 'asc')->get();
        return view('Siswa.siswa', compact('title', 'siswas', 'kelas_list'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function getSiswaByKelas($kelas_id)
    {
        $data = [];
        $siswas = Siswa::where('kelas_id', $kelas_id)->orderBy('nis', 'asc')->select('id', 'nama')->get();
        foreach($siswas as $siswa){
            $data[] = ['value' => $siswa['id'], 'label' => $siswa['nama']];
        }
        return response()->json($data, 200);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'nis' => 'required',
            'nama' => 'required',
            'gender' => 'required',
            'kelas_id' => 'required',
        ]);

        $siswa = Siswa::create($request->all());
        return back()->with('success', 'Siswa baru berhasil dibuat');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $siswa = Siswa::findOrFail($id);
        return response()->json($siswa, 200);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        $siswa = Siswa::findOrFail($request->edit_id);
        $siswa->update([
            'nis' => $request->edit_nis,
            'nama' => $request->edit_nama,
            'gender' => $request->edit_gender,
            'kelas_id' => $request->edit_kelas_id,
        ]);
        return back()->with('success', 'Siswa berhasil diperbarui');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $siswa = Siswa::findOrFail($id);
        if($siswa){
            $tidak_hadir_list = SiswaTakHadir::where('siswa_id', $id)->get();
            if($tidak_hadir_list){
                foreach($tidak_hadir_list as $item){
                    $item->delete();
                }
            }
            $siswa->delete();
        }
        return back()->with('success', 'Siswa berhasil dihapus');
    }

    public function import(Request $request){
        $request->validate([
            'file_siswa' => 'mimes:xls,xlsx'
        ], [
            'file_siswa.mimes' => 'File ditolak, hanya menerima file excel'
        ]);
        $data = $request->file('file_siswa');
        $file_name = $data->getClientOriginalName();
        $data->move('excel/Siswa', $file_name);
        Excel::import(new SiswaImport(), ('./excel/Siswa/' . $file_name));

        return back()->with('success', 'Data Siswa Berhasil Di Import');
    }
}
