<?php

namespace App\Http\Controllers;

use App\Imports\MapelImport;
use App\Models\Mapel;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class MapelController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $title = "Data Mapel";
        $mapels = Mapel::all();
        return view('Mapel.mapel', compact('title', 'mapels'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'mapel' => 'required',
        ]);

        $mapel = Mapel::create($request->all());
        return back()->with('success', 'Mapel baru berhasil dibuat');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $mapel = Mapel::findOrFail($id);
        return response()->json($mapel, 200);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        $mapel = Mapel::findOrFail($request->edit_id);
        $mapel->update([
            'mapel' => $request->edit_mapel,
        ]);
        return back()->with('success', 'Mapel berhasil diperbarui');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $mapel = Mapel::findOrFail($id);
        if($mapel){
            $mapel->delete();
        }
        return back()->with('success', 'Mapel berhasil dihapus');
    }

    public function import(Request $request){
        $request->validate([
            'file_mapel' => 'mimes:xls,xlsx'
        ], [
            'file_mapel.mimes' => 'File ditolak, hanya menerima file excel'
        ]);
        $data = $request->file('file_mapel');
        $file_name = $data->getClientOriginalName();
        $data->move('excel/Mapel', $file_name);
        Excel::import(new MapelImport(), ('./excel/Mapel/' . $file_name));

        return back()->with('success', 'Data Mapel Berhasil Di Import');
    }
}
