<?php

namespace App\Http\Controllers;

use App\Models\Jurnal;
use App\Models\Kehadiran;
use App\Models\Kelas;
use App\Models\Mapel;
use App\Models\SiswaTakHadir;
use App\Models\User;
use Illuminate\Http\Request;

class JurnalController extends Controller
{
    private function getMapel()
    {
        $mapel = Mapel::all();
        return $mapel;
    }
    private function getGuru()
    {
        $guru = User::where('role', 'guru')->get();
        return $guru;
    }
    private function getKelas()
    {
        $kelas = Kelas::all();
        return $kelas;
    }
    private function separateJurnal($jurnals)
    {
        $separated = [];
        foreach ($jurnals as $item) {
            $item['jurnal'] = explode(PHP_EOL, $item['jurnal']);
            array_push($separated, $item);
        }
        return $separated;
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $title = 'Data Jurnal';
        $mapel_list = $this->getMapel();
        $guru_list = $this->getGuru();
        $kelas_list = $this->getKelas();

        if (auth()->user()->role == 'admin') {
            $jurnals = Jurnal::with('kelas', 'mapel', 'user')->orderBy('date', 'desc')->get();
        } else {
            $jurnals = Jurnal::with('kelas', 'mapel', 'user')
                ->where('user_id', auth()->user()->id)
                ->orderBy('date', 'desc')
                ->get();
        }
        $jurnals = $this->separateJurnal($jurnals);
        return view('Jurnal.jurnal', compact('title', 'mapel_list', 'guru_list', 'kelas_list', 'jurnals'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        // dd($request->all());
        $request->validate([
            'kelas_id' => 'required',
            'mapel_id' => 'required',
            'judul' => 'required',
            'judul' => 'required',
            'jurnal' => 'required',
            'hadir' => 'required',
            'date' => 'required',
        ]);
        // Kehadiran Siswa
        $kehadiran = Kehadiran::create([
            'hadir' => $request->hadir,
            'sakit' => $request->sakit,
            'izin' => $request->izin,
            'alasan' => $request->alasan,
        ]);

        // Create Jurnal
        $request['user_id'] = auth()->user()->id;
        $request['kehadiran_id'] = $kehadiran['id'];
        $jurnal = Jurnal::create($request->all());

        // Ada yang tidak hadir ?? 😜
        if (!empty($request->sakit) || !empty($request->izin) || !empty($request->alasan)) {
            if (!empty($request->siswa_tak_hadir_value)) {
                $siswa = json_decode($request->siswa_tak_hadir_value, true);
                foreach ($siswa as $item) {
                    SiswaTakHadir::create([
                        'kehadiran_id' => $kehadiran['id'],
                        'siswa_id' => $item['value'],
                    ]);
                }
            }
        }

        return back()->with('success', 'Jurnal baru ditambahkan');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $jurnal = Jurnal::with('kehadiran.siswa_tak_hadir.siswa')->findOrFail($id);
        return response()->json($jurnal, 200);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        // dd($request->all());
        $jurnal = Jurnal::findOrFail($request->edit_id);
        $kehadiran_prev = Kehadiran::with('siswa_tak_hadir.siswa')->findOrFail($request->kehadiran_id);
        if ($kehadiran_prev) {
            $prev = [];
            foreach ($kehadiran_prev['siswa_tak_hadir'] as $item) {
                $data = [
                    'value' => $item['siswa_id'],
                    'label' => $item['siswa']['nama'],
                ];
                $prev[] = $data;
            }
            $kehadiran_prev = $prev;
        }
        $kehadiran_new = json_decode($request->edit_siswa_tak_hadir_value, true);

        // Jurnal
        $jurnal->update([
            'kelas_id' => $request->edit_kelas_id,
            'mapel_id' => $request->edit_mapel_id,
            'jam_ke_start' => $request->edit_jam_ke_start,
            'jam_ke_end' => $request->edit_jam_ke_end,
            'judul' => $request->edit_judul,
            'jurnal' => $request->edit_jurnal,
            'date' => $request->edit_date,
            'keterangan' => $request->edit_keterangan,
        ]);

        // Kehadiran
        $kehadiran = Kehadiran::findOrFail($request->kehadiran_id);
        $kehadiran->update([
            'hadir' => $request->edit_hadir,
            'sakit' => $request->edit_sakit,
            'izin' => $request->edit_izin,
            'alasan' => $request->edit_alasan,
        ]);

        // Siswa Tak Hadir
        $kehadiran_effect = $this->getKehadiranData($kehadiran_prev, $kehadiran_new);
        if (!empty($kehadiran_effect['new_data'])) {
            foreach ($kehadiran_effect['new_data'] as $item) {
                $siswa = SiswaTakHadir::create([
                    'siswa_id' => $item['value'],
                    'kehadiran_id' => $request->kehadiran_id,
                ]);
            }
        }

        if (!empty($kehadiran_effect['remove_data'])) {
            foreach ($kehadiran_effect['remove_data'] as $item) {
                $siswa = SiswaTakHadir::where('kehadiran_id', $request->kehadiran_id)
                    ->where('siswa_id', $item['value'])
                    ->first();
                if ($siswa) {
                    $siswa->delete();
                }
            }
        }

        return back()->with('success', 'Jurnal berhasil diperbarui');
    }

    private function getKehadiranData($prev, $new)
    {
        $new_data = [];
        $remove_data = [];

        $prev_values = array_column($prev, 'value');
        $new_values = array_column($new, 'value');

        // New
        foreach ($new as $new_item) {
            if (!in_array($new_item['value'], $prev_values)) {
                $new_data[] = $new_item;
            }
        }

        // Remove
        foreach ($prev as $prev_item) {
            if (!in_array($prev_item['value'], $new_values)) {
                $remove_data[] = $prev_item;
            }
        }

        return [
            'new_data' => $new_data,
            'remove_data' => $remove_data,
        ];
    }
    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $jurnal = Jurnal::findOrFail($id);
        $jurnal->delete();
        return back()->with('success', 'Jurnal berhasil dihapus');
    }

    public function export(Request $request)
    {
        $jurnals = Jurnal::with('user.mapel', 'kelas', 'kehadiran.siswa_tak_hadir.siswa')
            ->whereBetween('date', [$request->start_date, $request->end_date])
            ->where('kelas_id', $request->kelas_export)
            ->where('mapel_id', $request->mapel_export)
            ->orderBy('date', 'asc')->get();
        $jurnals = $this->separateJurnal($jurnals);
        $data = [
            "title" => 'Jurnal_' . auth()->user()->nama_lengkap,
            "nama_guru" => auth()->user()->nama_lengkap,
            "mapel" => Mapel::findOrFail($request->mapel_export)->mapel,
            "kelas" => Kelas::findOrFail($request->kelas_export)->kelas,
            "rentang_tanggal" => date_format(date_create($request->start_date), 'd F Y') . ' - ' . date_format(date_create($request->end_date), 'd F Y'),
            "jurnals" => $jurnals,
        ];

        return view('Jurnal.export', compact('data'));
    }
}
