<?php

namespace App\Http\Controllers;

use App\Imports\GuruImport;
use App\Models\Mapel;
use App\Models\User;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class GuruController extends Controller
{
    /**
     * Display a mapel listing of the resource.
     */
    private function getMapel(){
        $mapel = Mapel::all();
        return $mapel;
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $mapel_list = $this->getMapel();
        $title = "Data Guru";
        $gurus = User::with('mapel')->where('role', 'guru')->get();
        return view('Guru.guru', compact('title', 'gurus', 'mapel_list'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'nip' => 'required',
            'nama_lengkap' => 'required',
            'mapel_id' => 'required',
        ]);

        $request['role'] = 'guru';
        $request['nip'] = str_replace(' ', '', $request->nip);
        $request['password'] = bcrypt('12345');
        $user = User::create($request->all());
        return back()->with('success', 'Guru baru berhasil dibuat');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $guru = User::where('id', $id)->where('role', 'guru')->first();
        return response()->json($guru, 200);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        $user = User::findOrFail($request->edit_id);
        $user->update([
            'nip' => str_replace(' ', '', $request->edit_nip),
            'nama_lengkap' => $request->edit_nama_lengkap,
            'mapel_id' => $request->edit_mapel_id,
        ]);
        return back()->with('success', 'Guru berhasil diperbarui');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $guru = User::findOrFail($id);
        if($guru){
            $guru->delete();
        }
        return back()->with('success', 'Guru berhasil dihapus');
    }

    public function import(Request $request){
        $request->validate([
            'file_guru' => 'mimes:xls,xlsx'
        ], [
            'file_guru.mimes' => 'File ditolak, hanya menerima file excel'
        ]);
        $data = $request->file('file_guru');
        $file_name = $data->getClientOriginalName();
        $data->move('excel/Guru', $file_name);
        Excel::import(new GuruImport(), ('./excel/Guru/' . $file_name));

        return back()->with('success', 'Data Guru Berhasil Di Import');
    }
}
