<?php

namespace App\Http\Controllers;

use App\Models\Jurnal;
use App\Models\Mapel;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    private function forAdmin(){
        $title = "Dashboard";
        $guru = User::where('role', 'guru')->count();
        $mapel = Mapel::whereNot('id', 1)->count();
        return view('Dashboard.admin_dashboard', compact('title', 'guru', 'mapel'));
    }

    private function forGuru(){
        $title = "Dashboard";
        $my_jurnal = Jurnal::where('user_id', auth()->user()->id)->count();
        return view('Dashboard.guru_dashboard', compact('title', 'my_jurnal'));
    }

    public function index(){
        if(Auth::user()->role == 'admin'){
            return $this->forAdmin();
        }else{
            return $this->forGuru();
        }
    }
}
