<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class AuthController extends Controller
{
    public function index(){
        return view('Auth.login');
    }

    public function login(Request $request){
        Session::flash('nip',$request->nip);
        if(Auth::attempt(['nip' => $request->nip, 'password' => $request->password])){
            $request->session()->regenerate();
            return redirect()->intended('/');
        }else{
            return back()->with('failed', 'Login Gagal, Username atau Password Salah');
        }
    }

    public function logout(Request $request){
        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect('/login')->with('success', 'Logout Berhasil');
    }
}
